/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block;

import java.util.Optional;
import javax.annotation.Nullable;
import net.jitl.common.block.entity.BitterwoodCampfireBlockEntity;
import net.jitl.core.init.internal.JBlockEntities;
import net.jitl.core.init.internal.JBlockProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

public class BitterwoodCampfireBlock
extends CampfireBlock {
    public BitterwoodCampfireBlock() {
        super(true, 1, JBlockProperties.CAMPFIRE);
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack itemstack;
        BitterwoodCampfireBlockEntity campfireblockentity;
        Optional<RecipeHolder<CampfireCookingRecipe>> optional;
        BlockEntity blockentity = pLevel.getBlockEntity(pPos);
        if (blockentity instanceof BitterwoodCampfireBlockEntity && (optional = (campfireblockentity = (BitterwoodCampfireBlockEntity)blockentity).getCookableRecipe(itemstack = pPlayer.getItemInHand(pHand))).isPresent()) {
            if (!pLevel.isClientSide && campfireblockentity.placeFood((Entity)pPlayer, pPlayer.getAbilities().instabuild ? itemstack.copy() : itemstack, ((CampfireCookingRecipe)optional.get().value()).getCookingTime())) {
                pPlayer.awardStat(Stats.INTERACT_WITH_CAMPFIRE);
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.is(pNewState.getBlock())) {
            BlockEntity blockentity = pLevel.getBlockEntity(pPos);
            if (blockentity instanceof BitterwoodCampfireBlockEntity) {
                Containers.dropContents((Level)pLevel, (BlockPos)pPos, ((BitterwoodCampfireBlockEntity)blockentity).getItems());
            }
            super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public static void dowse(@Nullable Entity pEntity, LevelAccessor pLevel, BlockPos pPos, BlockState pState) {
        BlockEntity blockentity;
        if (pLevel.isClientSide()) {
            for (int i = 0; i < 20; ++i) {
                BitterwoodCampfireBlock.makeParticles((Level)((Level)pLevel), (BlockPos)pPos, (boolean)((Boolean)pState.getValue((Property)SIGNAL_FIRE)), (boolean)true);
            }
        }
        if ((blockentity = pLevel.getBlockEntity(pPos)) instanceof BitterwoodCampfireBlockEntity) {
            ((BitterwoodCampfireBlockEntity)blockentity).dowse();
        }
        pLevel.gameEvent(pEntity, (Holder)GameEvent.BLOCK_CHANGE, pPos);
    }

    public boolean placeLiquid(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        if (!((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && pFluidState.getType() == Fluids.WATER) {
            boolean flag = (Boolean)pState.getValue((Property)LIT);
            if (flag) {
                if (!pLevel.isClientSide()) {
                    pLevel.playSound(null, pPos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                BitterwoodCampfireBlock.dowse(null, pLevel, pPos, pState);
            }
            pLevel.setBlock(pPos, (BlockState)((BlockState)pState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            pLevel.scheduleTick(pPos, pFluidState.getType(), pFluidState.getType().getTickDelay((LevelReader)pLevel));
            return true;
        }
        return false;
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new BitterwoodCampfireBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.isClientSide) {
            return (Boolean)pState.getValue((Property)LIT) != false ? BitterwoodCampfireBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)JBlockEntities.BITTERWOOD_CAMPFIRE.get()), BitterwoodCampfireBlockEntity::particleTick) : null;
        }
        return (Boolean)pState.getValue((Property)LIT) != false ? BitterwoodCampfireBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)JBlockEntities.BITTERWOOD_CAMPFIRE.get()), BitterwoodCampfireBlockEntity::cookTick) : BitterwoodCampfireBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)JBlockEntities.BITTERWOOD_CAMPFIRE.get()), BitterwoodCampfireBlockEntity::cooldownTick);
    }
}

