/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block;

import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JParticleManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class CrystalFruit
extends Block {
    public CrystalFruit(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void animateTick(BlockState state, Level worldIn, BlockPos pos, RandomSource rand) {
        if (rand.nextInt(2) == 0) {
            double d0 = (double)pos.getX() + rand.nextDouble();
            double d1 = (double)pos.getY() - 0.04;
            double d2 = (double)pos.getZ() + rand.nextDouble();
            worldIn.addParticle((ParticleOptions)JParticleManager.CRYSTAL_FRUIT.get(), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.canSurvive((LevelReader)worldIn, currentPos)) {
            worldIn.scheduleTick(currentPos, (Block)this, 1);
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.above();
        BlockState blockstate = worldIn.getBlockState(blockpos);
        Block block = blockstate.getBlock();
        return block == JBlocks.ICY_IVY.get() || block == JBlocks.ICY_IVY_PLANT.get() || blockstate.isSolid();
    }
}

