/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CrystallizedDripstoneBlock
extends Block
implements Fallable,
SimpleWaterloggedBlock {
    public static final MapCodec<CrystallizedDripstoneBlock> CODEC = CrystallizedDripstoneBlock.simpleCodec(CrystallizedDripstoneBlock::new);
    public static final DirectionProperty TIP_DIRECTION = BlockStateProperties.VERTICAL_DIRECTION;
    public static final EnumProperty<DripstoneThickness> THICKNESS = BlockStateProperties.DRIPSTONE_THICKNESS;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape TIP_MERGE_SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_UP = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_DOWN = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape BASE_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    @NotNull
    public MapCodec<CrystallizedDripstoneBlock> codec() {
        return CODEC;
    }

    public CrystallizedDripstoneBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)TIP_DIRECTION, (Comparable)Direction.UP)).setValue(THICKNESS, (Comparable)DripstoneThickness.TIP)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_154157_) {
        p_154157_.add(new Property[]{TIP_DIRECTION, THICKNESS, WATERLOGGED});
    }

    protected boolean canSurvive(BlockState s, @NotNull LevelReader l, @NotNull BlockPos p) {
        return CrystallizedDripstoneBlock.isValidPointedDripstonePlacement(l, p, (Direction)s.getValue((Property)TIP_DIRECTION));
    }

    @NotNull
    protected BlockState updateShape(BlockState s, @NotNull Direction d, @NotNull BlockState s2, @NotNull LevelAccessor level, @NotNull BlockPos pos1, @NotNull BlockPos pos2) {
        if (((Boolean)s.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos1, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (d != Direction.UP && d != Direction.DOWN) {
            return s;
        }
        Direction direction = (Direction)s.getValue((Property)TIP_DIRECTION);
        if (direction == Direction.DOWN && level.getBlockTicks().hasScheduledTick(pos1, (Object)this)) {
            return s;
        }
        if (d == direction.getOpposite() && !this.canSurvive(s, (LevelReader)level, pos1)) {
            if (direction == Direction.DOWN) {
                level.scheduleTick(pos1, (Block)this, 2);
            } else {
                level.scheduleTick(pos1, (Block)this, 1);
            }
            return s;
        }
        boolean flag = s.getValue(THICKNESS) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness dripstonethickness = CrystallizedDripstoneBlock.calculateDripstoneThickness((LevelReader)level, pos1, direction, flag);
        return (BlockState)s.setValue(THICKNESS, (Comparable)dripstonethickness);
    }

    protected void onProjectileHit(Level l, @NotNull BlockState s, @NotNull BlockHitResult b, @NotNull Projectile p) {
        BlockPos blockpos;
        if (!l.isClientSide && p.mayInteract(l, blockpos = b.getBlockPos()) && p.mayBreak(l) && p instanceof ThrownTrident && p.getDeltaMovement().length() > 0.6) {
            l.destroyBlock(blockpos, true);
        }
    }

    public void fallOn(@NotNull Level l, BlockState d, @NotNull BlockPos p, @NotNull Entity e, float f) {
        if (d.getValue((Property)TIP_DIRECTION) == Direction.UP && d.getValue(THICKNESS) == DripstoneThickness.TIP) {
            e.causeFallDamage(f + 2.0f, 2.0f, l.damageSources().stalagmite());
        } else {
            super.fallOn(l, d, p, e, f);
        }
    }

    protected void tick(@NotNull BlockState s, @NotNull ServerLevel l, @NotNull BlockPos p, @NotNull RandomSource r) {
        if (CrystallizedDripstoneBlock.isStalagmite(s) && !this.canSurvive(s, (LevelReader)l, p)) {
            l.destroyBlock(p, true);
        } else {
            CrystallizedDripstoneBlock.spawnFallingStalactite(s, l, p);
        }
    }

    protected void randomTick(@NotNull BlockState s, @NotNull ServerLevel l, @NotNull BlockPos p, RandomSource r) {
        if (r.nextFloat() < 0.011377778f && CrystallizedDripstoneBlock.isStalactiteStartPos(s, (LevelReader)l, p)) {
            CrystallizedDripstoneBlock.growStalactiteOrStalagmiteIfPossible(s, l, p, r);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_154040_) {
        Direction direction;
        BlockPos blockpos;
        Level levelaccessor = p_154040_.getLevel();
        Direction direction1 = CrystallizedDripstoneBlock.calculateTipDirection((LevelReader)levelaccessor, blockpos = p_154040_.getClickedPos(), direction = p_154040_.getNearestLookingVerticalDirection().getOpposite());
        if (direction1 == null) {
            return null;
        }
        boolean flag = !p_154040_.isSecondaryUseActive();
        DripstoneThickness dripstonethickness = CrystallizedDripstoneBlock.calculateDripstoneThickness((LevelReader)levelaccessor, blockpos, direction1, flag);
        return dripstonethickness == null ? null : (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TIP_DIRECTION, (Comparable)direction1)).setValue(THICKNESS, (Comparable)dripstonethickness)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.getFluidState(blockpos).getType() == Fluids.WATER));
    }

    @NotNull
    protected FluidState getFluidState(BlockState p_154235_) {
        return (Boolean)p_154235_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_154235_);
    }

    @NotNull
    protected VoxelShape getOcclusionShape(BlockState p_154170_, BlockGetter p_154171_, BlockPos p_154172_) {
        return Shapes.empty();
    }

    @NotNull
    protected VoxelShape getShape(BlockState p_154117_, BlockGetter p_154118_, BlockPos p_154119_, CollisionContext p_154120_) {
        DripstoneThickness dripstonethickness = (DripstoneThickness)p_154117_.getValue(THICKNESS);
        VoxelShape voxelshape = dripstonethickness == DripstoneThickness.TIP_MERGE ? TIP_MERGE_SHAPE : (dripstonethickness == DripstoneThickness.TIP ? (p_154117_.getValue((Property)TIP_DIRECTION) == Direction.DOWN ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (dripstonethickness == DripstoneThickness.FRUSTUM ? FRUSTUM_SHAPE : (dripstonethickness == DripstoneThickness.MIDDLE ? MIDDLE_SHAPE : BASE_SHAPE)));
        Vec3 vec3 = p_154117_.getOffset(p_154118_, p_154119_);
        return voxelshape.move(vec3.x, 0.0, vec3.z);
    }

    protected boolean isCollisionShapeFullBlock(BlockState p_181235_, BlockGetter p_181236_, BlockPos p_181237_) {
        return false;
    }

    protected float getMaxHorizontalOffset() {
        return 0.125f;
    }

    public void onBrokenAfterFall(Level p_154059_, BlockPos p_154060_, FallingBlockEntity p_154061_) {
        if (!p_154061_.isSilent()) {
            p_154059_.levelEvent(1045, p_154060_, 0);
        }
    }

    public DamageSource getFallDamageSource(Entity p_254432_) {
        return p_254432_.damageSources().fallingStalactite(p_254432_);
    }

    private static void spawnFallingStalactite(BlockState state, ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
        BlockState blockstate = state;
        while (CrystallizedDripstoneBlock.isStalactite(blockstate)) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.fall((Level)level, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate);
            if (CrystallizedDripstoneBlock.isTip(blockstate, true)) {
                int i = Math.max(1 + pos.getY() - blockpos$mutableblockpos.getY(), 6);
                float f = 1.0f * (float)i;
                fallingblockentity.setHurtsEntities(f, 40);
                break;
            }
            blockpos$mutableblockpos.move(Direction.DOWN);
            blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos);
        }
    }

    @VisibleForTesting
    public static void growStalactiteOrStalagmiteIfPossible(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState blockstate2;
        BlockPos blockpos;
        BlockState blockstate1;
        BlockState blockstate = level.getBlockState(pos.above(1));
        if (CrystallizedDripstoneBlock.canGrow(blockstate, blockstate1 = level.getBlockState(pos.above(2))) && (blockpos = CrystallizedDripstoneBlock.findTip(state, (LevelAccessor)level, pos, 7, false)) != null && CrystallizedDripstoneBlock.canDrip(blockstate2 = level.getBlockState(blockpos)) && CrystallizedDripstoneBlock.canTipGrow(blockstate2, level, blockpos)) {
            if (random.nextBoolean()) {
                CrystallizedDripstoneBlock.grow(level, blockpos, Direction.DOWN);
            } else {
                CrystallizedDripstoneBlock.growStalagmiteBelow(level, blockpos);
            }
        }
    }

    public void animateTick(BlockState p_221870_, Level p_221871_, BlockPos p_221872_, RandomSource p_221873_) {
        float f;
        if (CrystallizedDripstoneBlock.canDrip(p_221870_) && !((f = p_221873_.nextFloat()) > 0.12f)) {
            CrystallizedDripstoneBlock.spawnDripParticle(p_221871_, p_221872_, p_221870_);
        }
    }

    private static void growStalagmiteBelow(ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
        for (int i = 0; i < 10; ++i) {
            blockpos$mutableblockpos.move(Direction.DOWN);
            BlockState blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos);
            if (!blockstate.getFluidState().isEmpty()) {
                return;
            }
            if (CrystallizedDripstoneBlock.isUnmergedTipWithDirection(blockstate, Direction.UP) && CrystallizedDripstoneBlock.canTipGrow(blockstate, level, (BlockPos)blockpos$mutableblockpos)) {
                CrystallizedDripstoneBlock.grow(level, (BlockPos)blockpos$mutableblockpos, Direction.UP);
                return;
            }
            if (!CrystallizedDripstoneBlock.isValidPointedDripstonePlacement((LevelReader)level, (BlockPos)blockpos$mutableblockpos, Direction.UP) || level.isWaterAt(blockpos$mutableblockpos.below())) continue;
            CrystallizedDripstoneBlock.grow(level, blockpos$mutableblockpos.below(), Direction.UP);
            return;
        }
    }

    private static void grow(ServerLevel server, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.relative(direction);
        BlockState blockstate = server.getBlockState(blockpos);
        if (CrystallizedDripstoneBlock.isUnmergedTipWithDirection(blockstate, direction.getOpposite())) {
            CrystallizedDripstoneBlock.createMergedTips(blockstate, (LevelAccessor)server, blockpos);
        } else if (blockstate.isAir() || blockstate.is(Blocks.WATER)) {
            CrystallizedDripstoneBlock.createDripstone((LevelAccessor)server, blockpos, direction, DripstoneThickness.TIP);
        }
    }

    private static void createDripstone(LevelAccessor level, BlockPos pos, Direction direction, DripstoneThickness thickness) {
        BlockState blockstate = (BlockState)((BlockState)((BlockState)((Block)JBlocks.POINTED_CRYSTALLIZED_DRIPSTONE.get()).defaultBlockState().setValue((Property)TIP_DIRECTION, (Comparable)direction)).setValue(THICKNESS, (Comparable)thickness)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER));
        level.setBlock(pos, blockstate, 3);
    }

    private static void createMergedTips(BlockState state, LevelAccessor level, BlockPos pos) {
        BlockPos blockpos;
        BlockPos blockpos1;
        if (state.getValue((Property)TIP_DIRECTION) == Direction.UP) {
            blockpos1 = pos;
            blockpos = pos.above();
        } else {
            blockpos = pos;
            blockpos1 = pos.below();
        }
        CrystallizedDripstoneBlock.createDripstone(level, blockpos, Direction.DOWN, DripstoneThickness.TIP_MERGE);
        CrystallizedDripstoneBlock.createDripstone(level, blockpos1, Direction.UP, DripstoneThickness.TIP_MERGE);
    }

    private static void spawnDripParticle(Level level, BlockPos pos, BlockState state) {
        SimpleParticleType particleoptions;
        Vec3 vec3 = state.getOffset((BlockGetter)level, pos);
        double d1 = (double)pos.getX() + 0.5 + vec3.x;
        double d2 = (double)((float)(pos.getY() + 1) - 0.6875f) - 0.0625;
        double d3 = (double)pos.getZ() + 0.5 + vec3.z;
        FlowingFluid fluid = Fluids.WATER;
        Object object = particleoptions = fluid.getFluidType().getDripInfo() != null ? fluid.getFluidType().getDripInfo().dripParticle() : ParticleTypes.DRIPPING_DRIPSTONE_WATER;
        if (particleoptions != null) {
            level.addParticle((ParticleOptions)particleoptions, d1, d2, d3, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    private static BlockPos findTip(BlockState state, LevelAccessor level, BlockPos pos, int maxIterations, boolean isTipMerge) {
        if (CrystallizedDripstoneBlock.isTip(state, isTipMerge)) {
            return pos;
        }
        Direction direction = (Direction)state.getValue((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202023_, p_202024_) -> p_202024_.is((Block)JBlocks.POINTED_CRYSTALLIZED_DRIPSTONE.get()) && p_202024_.getValue((Property)TIP_DIRECTION) == direction;
        return CrystallizedDripstoneBlock.findBlockVertical(level, pos, direction.getAxisDirection(), bipredicate, p_154168_ -> CrystallizedDripstoneBlock.isTip(p_154168_, isTipMerge), maxIterations).orElse(null);
    }

    @Nullable
    private static Direction calculateTipDirection(LevelReader level, BlockPos pos, Direction dir) {
        Direction direction;
        if (CrystallizedDripstoneBlock.isValidPointedDripstonePlacement(level, pos, dir)) {
            direction = dir;
        } else {
            if (!CrystallizedDripstoneBlock.isValidPointedDripstonePlacement(level, pos, dir.getOpposite())) {
                return null;
            }
            direction = dir.getOpposite();
        }
        return direction;
    }

    private static DripstoneThickness calculateDripstoneThickness(LevelReader level, BlockPos pos, Direction dir, boolean isTipMerge) {
        Direction direction = dir.getOpposite();
        BlockState blockstate = level.getBlockState(pos.relative(dir));
        if (!CrystallizedDripstoneBlock.isPointedDripstoneWithDirection(blockstate, direction)) {
            if (!CrystallizedDripstoneBlock.isPointedDripstoneWithDirection(blockstate, dir)) {
                return DripstoneThickness.TIP;
            }
            DripstoneThickness dripstonethickness = (DripstoneThickness)blockstate.getValue(THICKNESS);
            if (dripstonethickness != DripstoneThickness.TIP && dripstonethickness != DripstoneThickness.TIP_MERGE) {
                BlockState blockstate1 = level.getBlockState(pos.relative(direction));
                return !CrystallizedDripstoneBlock.isPointedDripstoneWithDirection(blockstate1, dir) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
            }
            return DripstoneThickness.FRUSTUM;
        }
        return !isTipMerge && blockstate.getValue(THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
    }

    public static boolean canDrip(BlockState state) {
        return CrystallizedDripstoneBlock.isStalactite(state) && state.getValue(THICKNESS) == DripstoneThickness.TIP && (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    private static boolean canTipGrow(BlockState state, ServerLevel level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)TIP_DIRECTION);
        BlockPos blockpos = pos.relative(direction);
        BlockState blockstate = level.getBlockState(blockpos);
        if (!blockstate.getFluidState().isEmpty()) {
            return false;
        }
        return blockstate.isAir() || CrystallizedDripstoneBlock.isUnmergedTipWithDirection(blockstate, direction.getOpposite());
    }

    private static boolean isValidPointedDripstonePlacement(LevelReader level, BlockPos pos, Direction dir) {
        BlockPos blockpos = pos.relative(dir.getOpposite());
        BlockState blockstate = level.getBlockState(blockpos);
        return blockstate.isFaceSturdy((BlockGetter)level, blockpos, dir) || CrystallizedDripstoneBlock.isPointedDripstoneWithDirection(blockstate, dir);
    }

    private static boolean isTip(BlockState state, boolean isTipMerge) {
        if (!state.is((Block)JBlocks.POINTED_CRYSTALLIZED_DRIPSTONE.get())) {
            return false;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)state.getValue(THICKNESS);
        return dripstonethickness == DripstoneThickness.TIP || isTipMerge && dripstonethickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean isUnmergedTipWithDirection(BlockState state, Direction dir) {
        return CrystallizedDripstoneBlock.isTip(state, false) && state.getValue((Property)TIP_DIRECTION) == dir;
    }

    private static boolean isStalactite(BlockState state) {
        return CrystallizedDripstoneBlock.isPointedDripstoneWithDirection(state, Direction.DOWN);
    }

    private static boolean isStalagmite(BlockState state) {
        return CrystallizedDripstoneBlock.isPointedDripstoneWithDirection(state, Direction.UP);
    }

    private static boolean isStalactiteStartPos(BlockState state, LevelReader level, BlockPos pos) {
        return CrystallizedDripstoneBlock.isStalactite(state) && !level.getBlockState(pos.above()).is((Block)JBlocks.POINTED_CRYSTALLIZED_DRIPSTONE.get());
    }

    protected boolean isPathfindable(@NotNull BlockState b, @NotNull PathComputationType p) {
        return false;
    }

    private static boolean isPointedDripstoneWithDirection(BlockState state, Direction dir) {
        return state.is((Block)JBlocks.POINTED_CRYSTALLIZED_DRIPSTONE.get()) && state.getValue((Property)TIP_DIRECTION) == dir;
    }

    private static boolean canGrow(BlockState dripstoneState, BlockState state) {
        return dripstoneState.is(JBlocks.CRYSTALLIZED_DRIPSTONE) && state.is(Blocks.WATER) && state.getFluidState().isSource();
    }

    private static Optional<BlockPos> findBlockVertical(LevelAccessor level, BlockPos pos, Direction.AxisDirection axis, BiPredicate<BlockPos, BlockState> positionalStatePredicate, Predicate<BlockState> statePredicate, int maxIterations) {
        Direction direction = Direction.get((Direction.AxisDirection)axis, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
        for (int i = 1; i < maxIterations; ++i) {
            blockpos$mutableblockpos.move(direction);
            BlockState blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos);
            if (statePredicate.test(blockstate)) {
                return Optional.of(blockpos$mutableblockpos.immutable());
            }
            if (!level.isOutsideBuildHeight(blockpos$mutableblockpos.getY()) && positionalStatePredicate.test((BlockPos)blockpos$mutableblockpos, blockstate)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }
}

