/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block;

import com.mojang.serialization.MapCodec;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.NetherVines;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class IcyIvyTopBlock
extends GrowingPlantHeadBlock {
    public static final MapCodec<IcyIvyTopBlock> CODEC = IcyIvyTopBlock.simpleCodec(IcyIvyTopBlock::new);
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)9.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public IcyIvyTopBlock(BlockBehaviour.Properties properties) {
        super(properties, Direction.DOWN, SHAPE, false, 0.1);
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    @NotNull
    protected Block getBodyBlock() {
        return (Block)JBlocks.ICY_IVY_PLANT.get();
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected MapCodec<? extends GrowingPlantHeadBlock> codec() {
        return CODEC;
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource pRandom) {
        return NetherVines.getBlocksToGrowWhenBonemealed((RandomSource)pRandom);
    }

    protected boolean canGrowInto(@NotNull BlockState state) {
        return NetherVines.isValidGrowthState((BlockState)state);
    }
}

