/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block;

import net.jitl.common.block.base.JBlock;
import net.jitl.common.entity.corba.SwampFly;
import net.jitl.core.init.internal.JBlockProperties;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JParticleManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class JBlockSwampLamp
extends JBlock {
    protected static final VoxelShape BOTTOM = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
    protected static final VoxelShape MID = Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0);
    protected static final VoxelShape TOP = Block.box((double)7.0, (double)9.0, (double)7.0, (double)9.0, (double)11.0, (double)9.0);

    public JBlockSwampLamp() {
        super(JBlockProperties.BOTTLE);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shapes.or((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{MID, TOP});
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        float x = (float)pos.getX() + 0.3f + random.nextFloat() / 3.0f;
        float y = (float)pos.getY() + 0.1f + random.nextFloat() / 4.0f;
        float z = (float)pos.getZ() + 0.3f + random.nextFloat() / 3.0f;
        if (random.nextInt(3) == 0) {
            level.addParticle((ParticleOptions)JParticleManager.SWAMP_FLY.get(), (double)x, (double)y, (double)z, 1.0, 1.0, 1.0);
        }
    }

    protected void spawnAfterBreak(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull ItemStack stack, boolean dropExperience) {
        super.spawnAfterBreak(state, level, pos, stack, dropExperience);
        SwampFly swampFly = (SwampFly)((EntityType)JEntities.SWAMP_FLY_TYPE.get()).create((Level)level);
        if (swampFly != null) {
            swampFly.moveTo((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            level.addFreshEntity((Entity)swampFly);
        }
    }
}

