/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.jitl.common.block.entity.JChestBlockEntity;
import net.jitl.core.init.internal.JBlockEntities;
import net.jitl.core.init.internal.JBlockProperties;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class JChestBlock
extends AbstractChestBlock<JChestBlockEntity>
implements SimpleWaterloggedBlock {
    public static final MapCodec<JChestBlock> CODEC = JChestBlock.simpleCodec(p_309280_ -> new JChestBlock());
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<ChestType> TYPE = BlockStateProperties.CHEST_TYPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape NORTHAABB = Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape SOUTHAABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)16.0);
    protected static final VoxelShape WESTAABB = Block.box((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape EASTAABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
    protected static final VoxelShape AABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    public static final BooleanProperty IS_LOCKED = BlockStateProperties.LOCKED;
    private static final DoubleBlockCombiner.Combiner<JChestBlockEntity, Optional<Container>> CHESTCOMBINER = new DoubleBlockCombiner.Combiner<JChestBlockEntity, Optional<Container>>(){

        @NotNull
        public Optional<Container> acceptDouble(JChestBlockEntity j, JChestBlockEntity j1) {
            return Optional.of(new CompoundContainer((Container)j, (Container)j1));
        }

        @NotNull
        public Optional<Container> acceptSingle(JChestBlockEntity j) {
            return Optional.of(j);
        }

        @NotNull
        public Optional<Container> acceptNone() {
            return Optional.empty();
        }
    };
    private static final DoubleBlockCombiner.Combiner<JChestBlockEntity, Optional<MenuProvider>> MENU_PROVIDER_COMBINER = new DoubleBlockCombiner.Combiner<JChestBlockEntity, Optional<MenuProvider>>(){

        @NotNull
        public Optional<MenuProvider> acceptDouble(final @NotNull JChestBlockEntity JChestBlockEntity3, final @NotNull JChestBlockEntity JChestBlockEntity4) {
            CompoundContainer container = new CompoundContainer((Container)JChestBlockEntity3, (Container)JChestBlockEntity4);
            return Optional.of(new MenuProvider(){
                final /* synthetic */ Container val$container;
                {
                    this.val$container = container;
                }

                @Nullable
                public AbstractContainerMenu createMenu(int id, @NotNull Inventory inventory, @NotNull Player player1) {
                    if (JChestBlockEntity3.canOpen(player1) && JChestBlockEntity4.canOpen(player1)) {
                        JChestBlockEntity3.unpackLootTable(inventory.player);
                        JChestBlockEntity4.unpackLootTable(inventory.player);
                        return ChestMenu.sixRows((int)id, (Inventory)inventory, (Container)this.val$container);
                    }
                    return null;
                }

                @NotNull
                public Component getDisplayName() {
                    if (JChestBlockEntity3.hasCustomName()) {
                        return JChestBlockEntity3.getDisplayName();
                    }
                    return JChestBlockEntity4.hasCustomName() ? JChestBlockEntity4.getDisplayName() : Component.translatable((String)"container.chestDouble");
                }
            });
        }

        @NotNull
        public Optional<MenuProvider> acceptSingle(JChestBlockEntity j) {
            return Optional.of(j);
        }

        @NotNull
        public Optional<MenuProvider> acceptNone() {
            return Optional.empty();
        }
    };

    public JChestBlock() {
        super(JBlockProperties.CHEST, () -> JBlockEntities.JCHEST.get());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)ChestType.SINGLE)).setValue((Property)IS_LOCKED, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public static DoubleBlockCombiner.BlockType getBlockType(BlockState state1) {
        ChestType chesttype = (ChestType)state1.getValue(TYPE);
        if (chesttype == ChestType.SINGLE) {
            return DoubleBlockCombiner.BlockType.SINGLE;
        }
        return chesttype == ChestType.RIGHT ? DoubleBlockCombiner.BlockType.FIRST : DoubleBlockCombiner.BlockType.SECOND;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (facingState.is((Block)this) && facing.getAxis().isHorizontal()) {
            ChestType chesttype = (ChestType)facingState.getValue(TYPE);
            if (state.getValue(TYPE) == ChestType.SINGLE && chesttype != ChestType.SINGLE && state.getValue((Property)FACING) == facingState.getValue((Property)FACING) && JChestBlock.getConnectedDirection(facingState) == facing.getOpposite()) {
                return (BlockState)state.setValue(TYPE, (Comparable)chesttype.getOpposite());
            }
        } else if (JChestBlock.getConnectedDirection(state) == facing) {
            return (BlockState)state.setValue(TYPE, (Comparable)ChestType.SINGLE);
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (state.getValue(TYPE) == ChestType.SINGLE) {
            return AABB;
        }
        return switch (JChestBlock.getConnectedDirection(state)) {
            case Direction.NORTH -> NORTHAABB;
            case Direction.SOUTH -> SOUTHAABB;
            case Direction.WEST -> WESTAABB;
            case Direction.EAST -> EASTAABB;
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(JChestBlock.getConnectedDirection(state)));
        };
    }

    public static Direction getConnectedDirection(BlockState state2) {
        Direction direction = (Direction)state2.getValue((Property)FACING);
        return state2.getValue(TYPE) == ChestType.LEFT ? direction.getClockWise() : direction.getCounterClockWise();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction2;
        ChestType chesttype = ChestType.SINGLE;
        Direction direction = context.getHorizontalDirection().getOpposite();
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = context.isSecondaryUseActive();
        Direction direction1 = context.getClickedFace();
        if (direction1.getAxis().isHorizontal() && flag && (direction2 = this.candidatePartnerFacing(context, direction1.getOpposite())) != null && direction2.getAxis() != direction1.getAxis()) {
            direction = direction2;
            ChestType chestType = chesttype = direction2.getCounterClockWise() == direction1.getOpposite() ? ChestType.RIGHT : ChestType.LEFT;
        }
        if (chesttype == ChestType.SINGLE && !flag) {
            if (direction == this.candidatePartnerFacing(context, direction.getClockWise())) {
                chesttype = ChestType.LEFT;
            } else if (direction == this.candidatePartnerFacing(context, direction.getCounterClockWise())) {
                chesttype = ChestType.RIGHT;
            }
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue(TYPE, (Comparable)chesttype)).setValue((Property)IS_LOCKED, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    private Direction candidatePartnerFacing(BlockPlaceContext context, Direction direction) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos().relative(direction));
        return blockstate.is((Block)this) && blockstate.getValue(TYPE) == ChestType.SINGLE ? (Direction)blockstate.getValue((Property)FACING) : null;
    }

    public void onRemove(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockentity = level.getBlockEntity(pos);
            if (blockentity instanceof Container) {
                if (!((Boolean)state.getValue((Property)IS_LOCKED)).booleanValue()) {
                    Containers.dropContents((Level)level, (BlockPos)pos, (Container)((Container)blockentity));
                }
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        Item heldItem = pPlayer.getMainHandItem().getItem();
        if (pLevel.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)pState.getValue((Property)IS_LOCKED)).booleanValue()) {
            pPlayer.sendSystemMessage((Component)Component.translatable((String)"jitl.chest.locked"));
            return InteractionResult.FAIL;
        }
        if (!((Boolean)pState.getValue((Property)IS_LOCKED)).booleanValue() && heldItem != JItems.PADLOCK.get()) {
            MenuProvider menuprovider = this.getMenuProvider(pState, pLevel, pPos);
            if (menuprovider != null) {
                pPlayer.openMenu(menuprovider);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public static Container getContainer(JChestBlock chest, BlockState state, Level level, BlockPos pos, boolean override) {
        return ((Optional)chest.combine(state, level, pos, override).apply(CHESTCOMBINER)).orElse(null);
    }

    protected MapCodec<? extends AbstractChestBlock<JChestBlockEntity>> codec() {
        return CODEC;
    }

    @NotNull
    public DoubleBlockCombiner.NeighborCombineResult<? extends JChestBlockEntity> combine(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, boolean override) {
        BiPredicate<LevelAccessor, BlockPos> bipredicate = override ? (world, pos2) -> false : JChestBlock::isJChestBlockedAt;
        return DoubleBlockCombiner.combineWithNeigbour((BlockEntityType)((BlockEntityType)this.blockEntityType.get()), JChestBlock::getBlockType, JChestBlock::getConnectedDirection, (DirectionProperty)FACING, (BlockState)state, (LevelAccessor)level, (BlockPos)pos, bipredicate);
    }

    @Nullable
    public MenuProvider getMenuProvider(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        return ((Optional)this.combine(state, level, pos, false).apply(MENU_PROVIDER_COMBINER)).orElse(null);
    }

    public static DoubleBlockCombiner.Combiner<JChestBlockEntity, Float2FloatFunction> opennessCombiner(final LidBlockEntity lid) {
        return new DoubleBlockCombiner.Combiner<JChestBlockEntity, Float2FloatFunction>(){

            @NotNull
            public Float2FloatFunction acceptDouble(@NotNull JChestBlockEntity JChestBlockEntity8, @NotNull JChestBlockEntity JChestBlockEntity9) {
                return tickDelta -> Math.max(JChestBlockEntity8.getOpenNess(tickDelta), JChestBlockEntity9.getOpenNess(tickDelta));
            }

            @NotNull
            public Float2FloatFunction acceptSingle(@NotNull JChestBlockEntity JChestBlockEntity10) {
                return JChestBlockEntity10::getOpenNess;
            }

            @NotNull
            public Float2FloatFunction acceptNone() {
                return arg_0 -> ((LidBlockEntity)lid).getOpenNess(arg_0);
            }
        };
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new JChestBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? JChestBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)this.blockEntityType.get()), JChestBlockEntity::lidAnimateTick) : null;
    }

    public static boolean isJChestBlockedAt(LevelAccessor level1, BlockPos pos1) {
        return JChestBlock.isBlockedChestByBlock((BlockGetter)level1, pos1) || JChestBlock.isCatSittingOnChest(level1, pos1);
    }

    private static boolean isBlockedChestByBlock(BlockGetter level, BlockPos pos) {
        BlockPos blockpos = pos.above();
        return level.getBlockState(blockpos).isRedstoneConductor(level, blockpos);
    }

    private static boolean isCatSittingOnChest(LevelAccessor level, BlockPos pos) {
        List list = level.getEntitiesOfClass(Cat.class, new AABB((double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 2), (double)(pos.getZ() + 1)));
        if (!list.isEmpty()) {
            for (Cat cat : list) {
                if (!cat.isInSittingPose()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)JChestBlock.getContainer(this, blockState, level, pos, false));
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        BlockState rotated = state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
        return mirror == Mirror.NONE ? rotated : (BlockState)rotated.setValue(TYPE, (Comparable)((ChestType)rotated.getValue(TYPE)).getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TYPE, WATERLOGGED, IS_LOCKED});
    }

    protected boolean isPathfindable(BlockState pState, PathComputationType pPathComputationType) {
        return false;
    }

    public void tick(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof JChestBlockEntity) {
            ((JChestBlockEntity)blockentity).recheckOpen();
        }
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        return (Boolean)state.getValue((Property)IS_LOCKED) != false ? 1000000.0f : super.getExplosionResistance(state, world, pos, explosion);
    }

    public float getDestroyProgress(BlockState state, @NotNull Player player, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return (Boolean)state.getValue((Property)IS_LOCKED) != false ? 0.0f : super.getDestroyProgress(state, player, level, pos);
    }
}

