/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block;

import com.mojang.serialization.MapCodec;
import net.jitl.core.init.internal.JBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObeliskBlock
extends BaseEntityBlock {
    public static final MapCodec<ObeliskBlock> CODEC = ObeliskBlock.simpleCodec(ObeliskBlock::new);
    private static final VoxelShape BASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[0]);

    public ObeliskBlock(BlockBehaviour.Properties p) {
        super(p);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)JBlockEntities.OBELISK.get()).create(pos, state);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        for (int i = 0; i < 10; ++i) {
            if (pRandom.nextInt(8) != 0) continue;
            double d0 = (double)pPos.getX() + (double)pRandom.nextFloat();
            double d1 = (double)pPos.getY() + 1.0;
            double d2 = (double)pPos.getZ() + (double)pRandom.nextFloat();
            pLevel.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, pState), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

