/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block;

import com.mojang.serialization.MapCodec;
import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.block.entity.SenterianAltarTile;
import net.jitl.common.capability.stats.PlayerStats;
import net.jitl.core.init.internal.JBlockEntities;
import net.jitl.core.init.internal.JDataAttachments;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SenterianAltar
extends BaseEntityBlock {
    public static final MapCodec<SenterianAltar> CODEC = SenterianAltar.simpleCodec(SenterianAltar::new);
    public static final BooleanProperty IS_ACTIVE = BooleanProperty.create((String)"is_active");
    public static final BooleanProperty IS_SPAWNING = BooleanProperty.create((String)"is_spawning");

    public SenterianAltar(BlockBehaviour.Properties p) {
        super(p);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)IS_ACTIVE, (Comparable)Boolean.FALSE));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)IS_SPAWNING, (Comparable)Boolean.FALSE));
    }

    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)IS_ACTIVE, (Comparable)Boolean.FALSE)).setValue((Property)IS_SPAWNING, (Comparable)Boolean.FALSE);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{IS_ACTIVE});
        builder.add(new Property[]{IS_SPAWNING});
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> entity) {
        return level.isClientSide ? null : SenterianAltar.createTickerHelper(entity, (BlockEntityType)((BlockEntityType)JBlockEntities.SENTERIAN_ALTAR.get()), SenterianAltarTile::serverTick);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource r) {
        if (this.getIsSpawning(state)) {
            for (int i = 0; i < 20; ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.WHITE_SMOKE, (double)((float)pos.getX() + 0.5f) - Mth.nextDouble((RandomSource)r, (double)-0.45, (double)0.75), (double)pos.getY() + Mth.nextDouble((RandomSource)r, (double)0.5, (double)2.0), (double)((float)pos.getZ() + 0.5f) - Mth.nextDouble((RandomSource)r, (double)-0.45, (double)0.75), r.nextGaussian() * 0.05, 0.15, r.nextGaussian() * 0.05);
            }
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, @NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        if (!this.getIsActive(state) && player.getMainHandItem().is((Item)JItems.SENTRY_OBSERVER.get())) {
            ((PlayerStats)player.getData(JDataAttachments.PLAYER_STATS)).addXP(EnumKnowledge.SENTERIAN, 15.0f, player);
            if (!this.getIsActive(state)) {
                level.setBlock(pos, (BlockState)state.setValue((Property)IS_ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
                if (!player.isCreative()) {
                    player.getMainHandItem().shrink(1);
                }
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public boolean getIsActive(BlockState state) {
        return (Boolean)state.getValue((Property)IS_ACTIVE);
    }

    public boolean getIsSpawning(BlockState state) {
        return (Boolean)state.getValue((Property)IS_SPAWNING);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)JBlockEntities.SENTERIAN_ALTAR.get()).create(pos, state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

