/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block;

import com.mojang.serialization.MapCodec;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.jitl.common.block.entity.SummoningTableTile;
import net.jitl.core.config.JCommonConfig;
import net.jitl.core.init.internal.JBlockEntities;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class SummoningTableBlock
extends BaseEntityBlock {
    public static final MapCodec<SummoningTableBlock> CODEC = SummoningTableBlock.simpleCodec(SummoningTableBlock::new);
    public static final BooleanProperty IS_ACTIVE = BooleanProperty.create((String)"is_active");
    public static final BooleanProperty SUMMON = BooleanProperty.create((String)"summon");
    public static BlockPattern STRUCTURE_PATTERN;

    public SummoningTableBlock(BlockBehaviour.Properties p) {
        super(p);
        SummoningTableBlock.getOrCreateStructurePattern();
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)IS_ACTIVE, (Comparable)Boolean.FALSE));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SUMMON, (Comparable)Boolean.FALSE));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)IS_ACTIVE, (Comparable)Boolean.FALSE)).setValue((Property)SUMMON, (Comparable)Boolean.FALSE);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{IS_ACTIVE});
        builder.add(new Property[]{SUMMON});
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)JBlockEntities.SUMMONING_TABLE.get()).create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> entity) {
        return level.isClientSide ? null : SummoningTableBlock.createTickerHelper(entity, (BlockEntityType)((BlockEntityType)JBlockEntities.SUMMONING_TABLE.get()), SummoningTableTile::serverTick);
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, @NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof SummoningTableTile && (this.isUsable(level, pos) || player.isCreative())) {
            player.openMenu((MenuProvider)((SummoningTableTile)blockentity));
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pos, RandomSource pRandom) {
        for (int i = 0; i < 10; ++i) {
            if (pRandom.nextInt(5) != 0) continue;
            double d0 = (double)pos.getX() + (double)pRandom.nextFloat();
            double d1 = (double)pos.getY() + 1.0;
            double d2 = (double)pos.getZ() + (double)pRandom.nextFloat();
            if (!this.isUsable(pLevel, pos)) continue;
            pLevel.addParticle((ParticleOptions)ParticleTypes.ENCHANT, d0, d1, d2, 0.0, 0.0, 0.0);
            if (((Boolean)pState.getValue((Property)IS_ACTIVE)).booleanValue()) {
                pLevel.addParticle((ParticleOptions)ParticleTypes.ENCHANT, d0, d1 + 0.2, d2, 0.0, 0.0, 0.0);
                pLevel.addParticle((ParticleOptions)ParticleTypes.CRIT, d0, d1 + 0.2, d2, 0.0, 0.0, 0.0);
            }
            if (!this.getIsSummoning(pState)) continue;
            pLevel.addParticle((ParticleOptions)ParticleTypes.CLOUD, (double)pos.getX() - Mth.nextDouble((RandomSource)pRandom, (double)-0.45, (double)0.75), (double)pos.getY() + Mth.nextDouble((RandomSource)pRandom, (double)0.5, (double)2.0), (double)pos.getZ() - Mth.nextDouble((RandomSource)pRandom, (double)-0.45, (double)0.75), pRandom.nextGaussian() * 0.05, 0.15, pRandom.nextGaussian() * 0.05);
        }
    }

    public boolean getIsSummoning(BlockState state) {
        return (Boolean)state.getValue((Property)SUMMON);
    }

    public boolean isUsable(Level level, BlockPos pos) {
        return STRUCTURE_PATTERN.find((LevelReader)level, pos.below(1).north(2).west(2)) != null || (Boolean)JCommonConfig.NEED_SUMMONING_STRUCTURE.get() == false;
    }

    public void onRemove(BlockState state, Level level, @NotNull BlockPos pos, BlockState blockState, boolean b) {
        if (!state.is(blockState.getBlock())) {
            BlockEntity blockentity = level.getBlockEntity(pos);
            if (blockentity instanceof SummoningTableTile) {
                if (level instanceof ServerLevel) {
                    Containers.dropContents((Level)level, (BlockPos)pos, (Container)((SummoningTableTile)blockentity));
                }
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, blockState, b);
        }
    }

    public static void getOrCreateStructurePattern() {
        if (STRUCTURE_PATTERN == null) {
            STRUCTURE_PATTERN = BlockPatternBuilder.start().aisle(new String[]{"_kek_", "l___l", "l___l", "cs_sc", "_____"}).aisle(new String[]{"k_k_k", "_____", "_____", "ss_ss", "_sss_"}).aisle(new String[]{"ekkke", "_____", "_____", "__o__", "_sss_"}).aisle(new String[]{"k_k_k", "_____", "_____", "ss_ss", "_sss_"}).aisle(new String[]{"_kek_", "l___l", "l___l", "cs_sc", "_____"}).where('_', BlockInWorld.hasState((Predicate)BlockStatePredicate.ANY)).where('k', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)((Block)JBlocks.BLOOD_ROCK.get())))).where('e', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)((Block)JBlocks.BLOOD_RUNE.get())))).where('l', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)((Block)JBlocks.BLOOD_PILLAR.get())))).where('c', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)((Block)JBlocks.CARVED_BLOOD_ROCK.get())))).where('s', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)((Block)JBlocks.BLOOD_BRICKS.get())))).where('o', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)((Block)JBlocks.OBELISK.get())))).build();
        }
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }
}

