/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.base;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class AttachedBlock
extends Block {
    protected static final VoxelShape DOWN_AABB = Block.box((double)3.0, (double)11.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape UP_AABB = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0);
    protected static final VoxelShape NORTH_AABB = Block.box((double)3.0, (double)3.0, (double)11.0, (double)13.0, (double)13.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)5.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)11.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)3.0, (double)3.0, (double)5.0, (double)13.0, (double)13.0);
    public static final DirectionProperty FACING = BlockStateProperties.FACING;

    public AttachedBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.UP));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        switch (direction) {
            case DOWN: {
                return DOWN_AABB;
            }
            case NORTH: {
                return NORTH_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
        }
        return UP_AABB;
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (!state.canSurvive((LevelReader)worldIn, pos)) {
            worldIn.destroyBlock(pos, true);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext blockItemUseContext) {
        BlockState blockstate = this.defaultBlockState();
        Level worldReader = blockItemUseContext.getLevel();
        BlockPos blockPos = blockItemUseContext.getClickedPos();
        Direction[] directions = blockItemUseContext.getNearestLookingDirections();
        for (int i = 0; i < directions.length; ++i) {
            Direction direction = directions[i];
            Direction direction2 = direction.getOpposite();
            if (!(blockstate = (BlockState)blockstate.setValue((Property)FACING, (Comparable)direction2)).canSurvive((LevelReader)worldReader, blockPos)) continue;
            return blockstate;
        }
        return null;
    }

    public boolean canSurvive(BlockState blockState, LevelReader reader, BlockPos blockPos) {
        Direction direction = (Direction)blockState.getValue((Property)FACING);
        BlockPos newPos = blockPos.relative(direction.getOpposite());
        BlockState newState = reader.getBlockState(newPos);
        return newState.isFaceSturdy((BlockGetter)reader, newPos, direction) && newState != Blocks.BEDROCK.defaultBlockState();
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.canSurvive((LevelReader)worldIn, currentPos)) {
            worldIn.scheduleTick(currentPos, (Block)this, 1);
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState rotate(BlockState b, Rotation r) {
        return (BlockState)b.setValue((Property)FACING, (Comparable)r.rotate((Direction)b.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState b, Mirror m) {
        return b.rotate(m.getRotation((Direction)b.getValue((Property)FACING)));
    }
}

