/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.base;

import net.jitl.core.init.internal.JBlockProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.IShearable;
import org.jetbrains.annotations.NotNull;

public class JLeavesBlock
extends Block
implements SimpleWaterloggedBlock,
IShearable {
    public static final IntegerProperty DISTANCE = BlockStateProperties.DISTANCE;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.PERSISTENT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public JLeavesBlock() {
        super(JBlockProperties.LEAVES);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(7))).setValue((Property)PERSISTENT, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    @NotNull
    public VoxelShape getBlockSupportShape(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return Shapes.empty();
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return (Integer)pState.getValue((Property)DISTANCE) == 7 && (Boolean)pState.getValue((Property)PERSISTENT) == false;
    }

    public void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (this.decaying(state)) {
            JLeavesBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos);
            level.removeBlock(pos, false);
        }
    }

    protected boolean decaying(BlockState s) {
        return (Boolean)s.getValue((Property)PERSISTENT) == false && (Integer)s.getValue((Property)DISTANCE) == 7;
    }

    public void tick(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        level.setBlock(pos, JLeavesBlock.updateDistance(state, (LevelAccessor)level, pos), 3);
    }

    public int getLightBlock(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return 1;
    }

    @NotNull
    public BlockState updateShape(BlockState pState, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        int i;
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if ((i = JLeavesBlock.getDistanceAt(facingState) + 1) != 1 || (Integer)pState.getValue((Property)DISTANCE) != i) {
            level.scheduleTick(currentPos, (Block)this, 1);
        }
        return pState;
    }

    private static BlockState updateDistance(BlockState state, LevelAccessor level, BlockPos pos) {
        int i = 7;
        BlockPos.MutableBlockPos b = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            b.setWithOffset((Vec3i)pos, direction);
            i = Math.min(i, JLeavesBlock.getDistanceAt(level.getBlockState((BlockPos)b)) + 1);
            if (i == 1) break;
        }
        return (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistanceAt(BlockState neighbor) {
        if (neighbor.is(BlockTags.LOGS)) {
            return 0;
        }
        return neighbor.getBlock() instanceof JLeavesBlock || neighbor.getBlock() instanceof LeavesBlock ? (Integer)neighbor.getValue((Property)DISTANCE) : 7;
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void animateTick(@NotNull BlockState state, Level level, BlockPos pos, @NotNull RandomSource random) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!level.isRainingAt(pos.above()) || random.nextInt(15) != 1 || (blockstate = level.getBlockState(blockpos = pos.below())).canOcclude() && blockstate.isFaceSturdy((BlockGetter)level, blockpos, Direction.UP))) {
            double d0 = (double)pos.getX() + random.nextDouble();
            double d1 = (double)pos.getY() - 0.05;
            double d2 = (double)pos.getZ() + random.nextDouble();
            level.addParticle((ParticleOptions)ParticleTypes.DRIPPING_WATER, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DISTANCE, PERSISTENT, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        BlockState blockstate = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)PERSISTENT, (Comparable)Boolean.TRUE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        return JLeavesBlock.updateDistance(blockstate, (LevelAccessor)pContext.getLevel(), pContext.getClickedPos());
    }
}

