/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.base;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class JWallBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final EnumProperty<WallSide> EAST_WALL = BlockStateProperties.EAST_WALL;
    public static final EnumProperty<WallSide> NORTH_WALL = BlockStateProperties.NORTH_WALL;
    public static final EnumProperty<WallSide> SOUTH_WALL = BlockStateProperties.SOUTH_WALL;
    public static final EnumProperty<WallSide> WEST_WALL = BlockStateProperties.WEST_WALL;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final Map<BlockState, VoxelShape> shapeByIndex;
    private final Map<BlockState, VoxelShape> collisionShapeByIndex;
    private static final VoxelShape POST_TEST = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape NORTH_TEST = Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SOUTH_TEST = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_TEST = Block.box((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape EAST_TEST = Block.box((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);

    public JWallBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)UP, (Comparable)Boolean.TRUE)).setValue(NORTH_WALL, (Comparable)WallSide.NONE)).setValue(EAST_WALL, (Comparable)WallSide.NONE)).setValue(SOUTH_WALL, (Comparable)WallSide.NONE)).setValue(WEST_WALL, (Comparable)WallSide.NONE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.shapeByIndex = this.makeShapes(16.0f, 14.0f, 16.0f);
        this.collisionShapeByIndex = this.makeShapes(24.0f, 24.0f, 24.0f);
    }

    private static VoxelShape applyWallShape(VoxelShape pBaseShape, WallSide pHeight, VoxelShape pLowShape, VoxelShape pTallShape) {
        if (pHeight == WallSide.TALL) {
            return Shapes.or((VoxelShape)pBaseShape, (VoxelShape)pTallShape);
        }
        return pHeight == WallSide.LOW ? Shapes.or((VoxelShape)pBaseShape, (VoxelShape)pLowShape) : pBaseShape;
    }

    private Map<BlockState, VoxelShape> makeShapes(float pWallPostHeight, float pWallLowHeight, float pWallTallHeight) {
        float f = 4.0f;
        float f1 = 12.0f;
        float f2 = 5.0f;
        float f3 = 11.0f;
        VoxelShape voxelshape = Block.box((double)f, (double)0.0, (double)f, (double)f1, (double)pWallPostHeight, (double)f1);
        VoxelShape voxelshape1 = Block.box((double)f2, (double)0.0, (double)0.0, (double)f3, (double)pWallLowHeight, (double)f3);
        VoxelShape voxelshape2 = Block.box((double)f2, (double)0.0, (double)f2, (double)f3, (double)pWallLowHeight, (double)16.0);
        VoxelShape voxelshape3 = Block.box((double)0.0, (double)0.0, (double)f2, (double)f3, (double)pWallLowHeight, (double)f3);
        VoxelShape voxelshape4 = Block.box((double)f2, (double)0.0, (double)f2, (double)16.0, (double)pWallLowHeight, (double)f3);
        VoxelShape voxelshape5 = Block.box((double)f2, (double)0.0, (double)0.0, (double)f3, (double)pWallTallHeight, (double)f3);
        VoxelShape voxelshape6 = Block.box((double)f2, (double)0.0, (double)f2, (double)f3, (double)pWallTallHeight, (double)16.0);
        VoxelShape voxelshape7 = Block.box((double)0.0, (double)0.0, (double)f2, (double)f3, (double)pWallTallHeight, (double)f3);
        VoxelShape voxelshape8 = Block.box((double)f2, (double)0.0, (double)f2, (double)16.0, (double)pWallTallHeight, (double)f3);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Boolean obool : UP.getPossibleValues()) {
            for (WallSide wallside : EAST_WALL.getPossibleValues()) {
                for (WallSide wallside1 : NORTH_WALL.getPossibleValues()) {
                    for (WallSide wallside2 : WEST_WALL.getPossibleValues()) {
                        for (WallSide wallside3 : SOUTH_WALL.getPossibleValues()) {
                            VoxelShape voxelshape9 = Shapes.empty();
                            voxelshape9 = JWallBlock.applyWallShape(voxelshape9, wallside, voxelshape4, voxelshape8);
                            voxelshape9 = JWallBlock.applyWallShape(voxelshape9, wallside2, voxelshape3, voxelshape7);
                            voxelshape9 = JWallBlock.applyWallShape(voxelshape9, wallside1, voxelshape1, voxelshape5);
                            voxelshape9 = JWallBlock.applyWallShape(voxelshape9, wallside3, voxelshape2, voxelshape6);
                            if (obool.booleanValue()) {
                                voxelshape9 = Shapes.or((VoxelShape)voxelshape9, (VoxelShape)voxelshape);
                            }
                            BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UP, (Comparable)obool)).setValue(EAST_WALL, (Comparable)wallside)).setValue(WEST_WALL, (Comparable)wallside2)).setValue(NORTH_WALL, (Comparable)wallside1)).setValue(SOUTH_WALL, (Comparable)wallside3);
                            builder.put((Object)((BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)), (Object)voxelshape9);
                            builder.put((Object)((BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.TRUE)), (Object)voxelshape9);
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return this.shapeByIndex.get(pState);
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return this.collisionShapeByIndex.get(pState);
    }

    protected boolean isPathfindable(BlockState pState, PathComputationType pPathComputationType) {
        return false;
    }

    private boolean connectsTo(BlockState pState, boolean pSideSolid, Direction pDirection) {
        Block block = pState.getBlock();
        boolean flag = block instanceof FenceGateBlock && FenceGateBlock.connectsToDirection((BlockState)pState, (Direction)pDirection);
        return pState.is(BlockTags.WALLS) || block instanceof JWallBlock || block instanceof WallBlock || !JWallBlock.isExceptionForConnection((BlockState)pState) && pSideSolid || block instanceof IronBarsBlock || flag;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Level levelreader = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        BlockPos blockpos1 = blockpos.north();
        BlockPos blockpos2 = blockpos.east();
        BlockPos blockpos3 = blockpos.south();
        BlockPos blockpos4 = blockpos.west();
        BlockPos blockpos5 = blockpos.above();
        BlockState blockstate = levelreader.getBlockState(blockpos1);
        BlockState blockstate1 = levelreader.getBlockState(blockpos2);
        BlockState blockstate2 = levelreader.getBlockState(blockpos3);
        BlockState blockstate3 = levelreader.getBlockState(blockpos4);
        BlockState blockstate4 = levelreader.getBlockState(blockpos5);
        boolean flag = this.connectsTo(blockstate, blockstate.isFaceSturdy((BlockGetter)levelreader, blockpos1, Direction.SOUTH), Direction.SOUTH);
        boolean flag1 = this.connectsTo(blockstate1, blockstate1.isFaceSturdy((BlockGetter)levelreader, blockpos2, Direction.WEST), Direction.WEST);
        boolean flag2 = this.connectsTo(blockstate2, blockstate2.isFaceSturdy((BlockGetter)levelreader, blockpos3, Direction.NORTH), Direction.NORTH);
        boolean flag3 = this.connectsTo(blockstate3, blockstate3.isFaceSturdy((BlockGetter)levelreader, blockpos4, Direction.EAST), Direction.EAST);
        BlockState blockstate5 = (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        return this.updateShape((LevelReader)levelreader, blockstate5, blockpos5, blockstate4, flag, flag1, flag2, flag3);
    }

    @NotNull
    public BlockState updateShape(BlockState pState, @NotNull Direction pFacing, @NotNull BlockState pFacingState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pFacingPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        if (pFacing == Direction.DOWN) {
            return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        }
        return pFacing == Direction.UP ? this.topUpdate((LevelReader)pLevel, pState, pFacingPos, pFacingState) : this.sideUpdate((LevelReader)pLevel, pCurrentPos, pState, pFacingPos, pFacingState, pFacing);
    }

    private static boolean isConnected(BlockState pState, Property<WallSide> pHeightProperty) {
        return pState.getValue(pHeightProperty) != WallSide.NONE;
    }

    private static boolean isCovered(VoxelShape pFirstShape, VoxelShape pSecondShape) {
        return !Shapes.joinIsNotEmpty((VoxelShape)pSecondShape, (VoxelShape)pFirstShape, (BooleanOp)BooleanOp.ONLY_FIRST);
    }

    private BlockState topUpdate(LevelReader pLevel, BlockState pState, BlockPos pPos, BlockState pSecondState) {
        boolean flag = JWallBlock.isConnected(pState, NORTH_WALL);
        boolean flag1 = JWallBlock.isConnected(pState, EAST_WALL);
        boolean flag2 = JWallBlock.isConnected(pState, SOUTH_WALL);
        boolean flag3 = JWallBlock.isConnected(pState, WEST_WALL);
        return this.updateShape(pLevel, pState, pPos, pSecondState, flag, flag1, flag2, flag3);
    }

    private BlockState sideUpdate(LevelReader pLevel, BlockPos pFirstPos, BlockState pFirstState, BlockPos pSecondPos, BlockState pSecondState, Direction pDir) {
        Direction direction = pDir.getOpposite();
        boolean flag = pDir == Direction.NORTH ? this.connectsTo(pSecondState, pSecondState.isFaceSturdy((BlockGetter)pLevel, pSecondPos, direction), direction) : JWallBlock.isConnected(pFirstState, NORTH_WALL);
        boolean flag1 = pDir == Direction.EAST ? this.connectsTo(pSecondState, pSecondState.isFaceSturdy((BlockGetter)pLevel, pSecondPos, direction), direction) : JWallBlock.isConnected(pFirstState, EAST_WALL);
        boolean flag2 = pDir == Direction.SOUTH ? this.connectsTo(pSecondState, pSecondState.isFaceSturdy((BlockGetter)pLevel, pSecondPos, direction), direction) : JWallBlock.isConnected(pFirstState, SOUTH_WALL);
        boolean flag3 = pDir == Direction.WEST ? this.connectsTo(pSecondState, pSecondState.isFaceSturdy((BlockGetter)pLevel, pSecondPos, direction), direction) : JWallBlock.isConnected(pFirstState, WEST_WALL);
        BlockPos blockpos = pFirstPos.above();
        BlockState blockstate = pLevel.getBlockState(blockpos);
        return this.updateShape(pLevel, pFirstState, blockpos, blockstate, flag, flag1, flag2, flag3);
    }

    private BlockState updateShape(LevelReader pLevel, BlockState pState, BlockPos pPos, BlockState pNeighbour, boolean pNorthConnection, boolean pEastConnection, boolean pSouthConnection, boolean pWestConnection) {
        VoxelShape voxelshape = pNeighbour.getCollisionShape((BlockGetter)pLevel, pPos).getFaceShape(Direction.DOWN);
        BlockState blockstate = this.updateSides(pState, pNorthConnection, pEastConnection, pSouthConnection, pWestConnection, voxelshape);
        return (BlockState)blockstate.setValue((Property)UP, (Comparable)Boolean.valueOf(this.shouldRaisePost(blockstate, pNeighbour, voxelshape)));
    }

    private boolean shouldRaisePost(BlockState pState, BlockState pNeighbour, VoxelShape pShape) {
        boolean flag6;
        boolean flag5;
        boolean flag;
        boolean bl = flag = pNeighbour.getBlock() instanceof WallBlock && (Boolean)pNeighbour.getValue((Property)UP) != false;
        if (flag) {
            return true;
        }
        WallSide wallside = (WallSide)pState.getValue(NORTH_WALL);
        WallSide wallside1 = (WallSide)pState.getValue(SOUTH_WALL);
        WallSide wallside2 = (WallSide)pState.getValue(EAST_WALL);
        WallSide wallside3 = (WallSide)pState.getValue(WEST_WALL);
        boolean flag1 = wallside1 == WallSide.NONE;
        boolean flag2 = wallside3 == WallSide.NONE;
        boolean flag3 = wallside2 == WallSide.NONE;
        boolean flag4 = wallside == WallSide.NONE;
        boolean bl2 = flag5 = flag4 && flag1 && flag2 && flag3 || flag4 != flag1 || flag2 != flag3;
        if (flag5) {
            return true;
        }
        boolean bl3 = flag6 = wallside == WallSide.TALL && wallside1 == WallSide.TALL || wallside2 == WallSide.TALL && wallside3 == WallSide.TALL;
        if (flag6) {
            return false;
        }
        return pNeighbour.is(BlockTags.WALL_POST_OVERRIDE) || JWallBlock.isCovered(pShape, POST_TEST);
    }

    private BlockState updateSides(BlockState pState, boolean pNorthConnection, boolean pEastConnection, boolean pSouthConnection, boolean pWestConnection, VoxelShape pWallShape) {
        return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue(NORTH_WALL, (Comparable)this.makeWallState(pNorthConnection, pWallShape, NORTH_TEST))).setValue(EAST_WALL, (Comparable)this.makeWallState(pEastConnection, pWallShape, EAST_TEST))).setValue(SOUTH_WALL, (Comparable)this.makeWallState(pSouthConnection, pWallShape, SOUTH_TEST))).setValue(WEST_WALL, (Comparable)this.makeWallState(pWestConnection, pWallShape, WEST_TEST));
    }

    private WallSide makeWallState(boolean pAllowConnection, VoxelShape pShape, VoxelShape pNeighbourShape) {
        if (pAllowConnection) {
            return JWallBlock.isCovered(pShape, pNeighbourShape) ? WallSide.TALL : WallSide.LOW;
        }
        return WallSide.NONE;
    }

    @NotNull
    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    public boolean propagatesSkylightDown(BlockState pState, @NotNull BlockGetter pReader, @NotNull BlockPos pPos) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) == false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{UP, NORTH_WALL, EAST_WALL, WEST_WALL, SOUTH_WALL, WATERLOGGED});
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState pState, Rotation pRotation) {
        return switch (pRotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue(NORTH_WALL, (Comparable)((WallSide)pState.getValue(SOUTH_WALL)))).setValue(EAST_WALL, (Comparable)((WallSide)pState.getValue(WEST_WALL)))).setValue(SOUTH_WALL, (Comparable)((WallSide)pState.getValue(NORTH_WALL)))).setValue(WEST_WALL, (Comparable)((WallSide)pState.getValue(EAST_WALL)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue(NORTH_WALL, (Comparable)((WallSide)pState.getValue(EAST_WALL)))).setValue(EAST_WALL, (Comparable)((WallSide)pState.getValue(SOUTH_WALL)))).setValue(SOUTH_WALL, (Comparable)((WallSide)pState.getValue(WEST_WALL)))).setValue(WEST_WALL, (Comparable)((WallSide)pState.getValue(NORTH_WALL)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue(NORTH_WALL, (Comparable)((WallSide)pState.getValue(WEST_WALL)))).setValue(EAST_WALL, (Comparable)((WallSide)pState.getValue(NORTH_WALL)))).setValue(SOUTH_WALL, (Comparable)((WallSide)pState.getValue(EAST_WALL)))).setValue(WEST_WALL, (Comparable)((WallSide)pState.getValue(SOUTH_WALL)));
            default -> pState;
        };
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState pState, Mirror pMirror) {
        return switch (pMirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)pState.setValue(NORTH_WALL, (Comparable)((WallSide)pState.getValue(SOUTH_WALL)))).setValue(SOUTH_WALL, (Comparable)((WallSide)pState.getValue(NORTH_WALL)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)pState.setValue(EAST_WALL, (Comparable)((WallSide)pState.getValue(WEST_WALL)))).setValue(WEST_WALL, (Comparable)((WallSide)pState.getValue(EAST_WALL)));
            default -> super.mirror(pState, pMirror);
        };
    }
}

