/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.crop;

import net.jitl.common.block.base.JCropBlock;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.NotNull;

public class AirrootCropBlock
extends JCropBlock {
    public static final int MAX_AGE = 4;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_4;

    public AirrootCropBlock() {
        super(JCropBlock.DimensionCrops.CLOUDIA);
    }

    @NotNull
    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 4;
    }

    protected int getBonemealAgeIncrease(@NotNull Level pLevel) {
        return super.getBonemealAgeIncrease(pLevel) / 4;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{AGE});
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    }

    @NotNull
    protected ItemLike getBaseSeedId() {
        return (ItemLike)JItems.AIRROOT_SEEDS.get();
    }

    public void growCrops(Level pLevel, BlockPos pPos, BlockState pState) {
        int age;
        int j;
        int i = this.getAge(pState) + this.getBonemealAgeIncrease(pLevel);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        if ((age = this.getAge(pState)) == 3) {
            pLevel.setBlock(pPos, ((Block)JBlocks.AIRROOT_MELON.get()).defaultBlockState(), 2);
        } else {
            pLevel.setBlock(pPos, this.getStateForAge(i), 2);
        }
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        float f;
        int i;
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        if (pLevel.getRawBrightness(pPos, 0) >= 9 && (i = this.getAge(pState)) < this.getMaxAge() && CommonHooks.canCropGrow((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.nextInt((int)(25.0f / (f = AirrootCropBlock.getGrowthSpeed((BlockState)this.defaultBlockState(), (BlockGetter)pLevel, (BlockPos)pPos))) + 1) == 0 ? 1 : 0) != 0)) {
            if (i == 3) {
                pLevel.setBlock(pPos, ((Block)JBlocks.AIRROOT_MELON.get()).defaultBlockState(), 2);
            } else {
                pLevel.setBlock(pPos, this.getStateForAge(i + 1), 2);
            }
            CommonHooks.fireCropGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return true;
    }
}

