/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.jitl.common.block.BitterwoodCampfireBlock;
import net.jitl.core.init.internal.JBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class BitterwoodCampfireBlockEntity
extends BlockEntity
implements Clearable {
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private final int[] cookingProgress = new int[4];
    private final int[] cookingTime = new int[4];
    private final RecipeManager.CachedCheck<SingleRecipeInput, CampfireCookingRecipe> quickCheck = RecipeManager.createCheck((RecipeType)RecipeType.CAMPFIRE_COOKING);

    public BitterwoodCampfireBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)JBlockEntities.BITTERWOOD_CAMPFIRE.get(), pPos, pBlockState);
    }

    public static void cookTick(Level pLevel, BlockPos pPos, BlockState pState, BitterwoodCampfireBlockEntity pBlockEntity) {
        boolean flag = false;
        for (int i = 0; i < pBlockEntity.items.size(); ++i) {
            SingleRecipeInput singlerecipeinput;
            ItemStack itemstack1;
            ItemStack itemstack = (ItemStack)pBlockEntity.items.get(i);
            if (itemstack.isEmpty()) continue;
            flag = true;
            int n = i;
            pBlockEntity.cookingProgress[n] = pBlockEntity.cookingProgress[n] + 1;
            if (pBlockEntity.cookingProgress[i] < pBlockEntity.cookingTime[i] || !(itemstack1 = pBlockEntity.quickCheck.getRecipeFor((RecipeInput)(singlerecipeinput = new SingleRecipeInput(itemstack)), pLevel).map(p_335297_ -> ((CampfireCookingRecipe)p_335297_.value()).assemble(singlerecipeinput, (HolderLookup.Provider)pLevel.registryAccess())).orElse(itemstack)).isItemEnabled(pLevel.enabledFeatures())) continue;
            Containers.dropItemStack((Level)pLevel, (double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ(), (ItemStack)itemstack1);
            pBlockEntity.items.set(i, (Object)ItemStack.EMPTY);
            pLevel.sendBlockUpdated(pPos, pState, pState, 3);
            pLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pPos, GameEvent.Context.of((BlockState)pState));
        }
        if (flag) {
            BitterwoodCampfireBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public static void cooldownTick(Level pLevel, BlockPos pPos, BlockState pState, BitterwoodCampfireBlockEntity pBlockEntity) {
        boolean flag = false;
        for (int i = 0; i < pBlockEntity.items.size(); ++i) {
            if (pBlockEntity.cookingProgress[i] <= 0) continue;
            flag = true;
            pBlockEntity.cookingProgress[i] = Mth.clamp((int)(pBlockEntity.cookingProgress[i] - 2), (int)0, (int)pBlockEntity.cookingTime[i]);
        }
        if (flag) {
            BitterwoodCampfireBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public static void particleTick(Level pLevel, BlockPos pPos, BlockState pState, BitterwoodCampfireBlockEntity pBlockEntity) {
        RandomSource randomsource = pLevel.random;
        if (randomsource.nextFloat() < 0.11f) {
            for (int i = 0; i < randomsource.nextInt(2) + 2; ++i) {
                BitterwoodCampfireBlock.makeParticles((Level)pLevel, (BlockPos)pPos, (boolean)((Boolean)pState.getValue((Property)CampfireBlock.SIGNAL_FIRE)), (boolean)false);
            }
        }
        int l = ((Direction)pState.getValue((Property)BitterwoodCampfireBlock.FACING)).get2DDataValue();
        for (int j = 0; j < pBlockEntity.items.size(); ++j) {
            if (((ItemStack)pBlockEntity.items.get(j)).isEmpty() || !(randomsource.nextFloat() < 0.2f)) continue;
            Direction direction = Direction.from2DDataValue((int)Math.floorMod(j + l, 4));
            float f = 0.3125f;
            double d0 = (double)pPos.getX() + 0.5 - (double)((float)direction.getStepX() * 0.3125f) + (double)((float)direction.getClockWise().getStepX() * 0.3125f);
            double d1 = (double)pPos.getY() + 0.5;
            double d2 = (double)pPos.getZ() + 0.5 - (double)((float)direction.getStepZ() * 0.3125f) + (double)((float)direction.getClockWise().getStepZ() * 0.3125f);
            for (int k = 0; k < 4; ++k) {
                pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.items.clear();
        ContainerHelper.loadAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
        if (pTag.contains("CookingTimes", 11)) {
            int[] aint = pTag.getIntArray("CookingTimes");
            System.arraycopy(aint, 0, this.cookingProgress, 0, Math.min(this.cookingTime.length, aint.length));
        }
        if (pTag.contains("CookingTotalTimes", 11)) {
            int[] aint1 = pTag.getIntArray("CookingTotalTimes");
            System.arraycopy(aint1, 0, this.cookingTime, 0, Math.min(this.cookingTime.length, aint1.length));
        }
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        ContainerHelper.saveAllItems((CompoundTag)pTag, this.items, (boolean)true, (HolderLookup.Provider)pRegistries);
        pTag.putIntArray("CookingTimes", this.cookingProgress);
        pTag.putIntArray("CookingTotalTimes", this.cookingTime);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag compoundtag = new CompoundTag();
        ContainerHelper.saveAllItems((CompoundTag)compoundtag, this.items, (boolean)true, (HolderLookup.Provider)pRegistries);
        return compoundtag;
    }

    public Optional<RecipeHolder<CampfireCookingRecipe>> getCookableRecipe(ItemStack pStack) {
        return this.items.stream().noneMatch(ItemStack::isEmpty) ? Optional.empty() : this.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(pStack), this.level);
    }

    public boolean placeFood(@Nullable Entity pEntity, ItemStack pStack, int pCookTime) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.items.get(i);
            if (!itemstack.isEmpty()) continue;
            this.cookingTime[i] = pCookTime;
            this.cookingProgress[i] = 0;
            this.items.set(i, (Object)pStack.split(1));
            this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.Context.of((Entity)pEntity, (BlockState)this.getBlockState()));
            this.markUpdated();
            return true;
        }
        return false;
    }

    private void markUpdated() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public void clearContent() {
        this.items.clear();
    }

    public void dowse() {
        if (this.level != null) {
            this.markUpdated();
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput pComponentInput) {
        super.applyImplicitComponents(pComponentInput);
        ((ItemContainerContents)pComponentInput.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.getItems());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.getItems()));
    }

    public void removeComponentsFromTag(CompoundTag pTag) {
        pTag.remove("Items");
    }
}

