/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.entity;

import net.jitl.core.init.internal.JBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class PedestalTile
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> inventory = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);

    public PedestalTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)JBlockEntities.PEDESTAL.get(), pos, state);
    }

    @NotNull
    protected NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    protected void setItems(@NotNull NonNullList<ItemStack> itemsIn) {
        this.inventory = itemsIn;
    }

    protected AbstractContainerMenu createMenu(int id, @NotNull Inventory player) {
        return null;
    }

    public int getContainerSize() {
        return 1;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)pRegistries);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        ContainerHelper.saveAllItems((CompoundTag)pTag, this.inventory, (HolderLookup.Provider)pRegistries);
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)"jitl.tile.pedestal");
    }
}

