/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.entity;

import net.jitl.common.block.SenterianAltar;
import net.jitl.common.entity.base.JMonsterEntity;
import net.jitl.common.entity.senterian.MiniSentryLord;
import net.jitl.common.entity.senterian.MiniSentryStalker;
import net.jitl.common.entity.senterian.MiniSentryWalker;
import net.jitl.core.init.internal.JBlockEntities;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SenterianAltarTile
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int spawnTimer;
    public int spawnCount;
    private final RawAnimation ROTATE = RawAnimation.begin().thenLoop("animation.senterian_altar.active");
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.senterian_altar.idle");

    public SenterianAltarTile(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)JBlockEntities.SENTERIAN_ALTAR.get(), pPos, pBlockState);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.putInt("spawnTimer", 0);
        tag.putInt("spawnCount", 0);
    }

    public void loadAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(tag, pRegistries);
        this.spawnTimer = tag.getInt("spawnTimer");
        this.spawnCount = tag.getInt("spawnCount");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 5, state -> {
            if (((Boolean)((SenterianAltarTile)state.getAnimatable()).getBlockState().getValue((Property)SenterianAltar.IS_ACTIVE)).booleanValue()) {
                return state.setAndContinue(this.ROTATE);
            }
            return state.setAndContinue(this.IDLE);
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SenterianAltarTile entity) {
        boolean isFull = (Boolean)state.getValue((Property)SenterianAltar.IS_ACTIVE);
        boolean isSpawning = (Boolean)state.getValue((Property)SenterianAltar.IS_SPAWNING);
        if (isFull) {
            if (entity.spawnTimer == 0) {
                entity.spawnTimer = 50;
                level.playSound(null, pos, (SoundEvent)JSounds.SENTRY_ALTAR_ACTIVATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (entity.spawnTimer == 5) {
                level.playSound(null, pos, (SoundEvent)JSounds.SENTRY_ALTAR_DEACTIVATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (entity.spawnTimer >= 0) {
                --entity.spawnTimer;
            }
            if (entity.spawnTimer <= 0) {
                entity.spawnTimer = 0;
            }
            if (entity.spawnTimer == 0) {
                entity.spawnMob(pos, level);
                level.setBlock(pos, (BlockState)state.setValue((Property)SenterianAltar.IS_SPAWNING, (Comparable)Boolean.valueOf(true)), 2);
                ++entity.spawnCount;
            }
            if (entity.spawnCount == 5) {
                entity.spawnCount = 0;
                level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)SenterianAltar.IS_ACTIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)SenterianAltar.IS_SPAWNING, (Comparable)Boolean.valueOf(false)), 2);
            }
        }
    }

    private void spawnMob(BlockPos pos, Level level) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        JMonsterEntity mob = null;
        RandomSource random = RandomSource.create();
        switch (random.nextInt(3)) {
            case 0: {
                JMonsterEntity jMonsterEntity = new MiniSentryLord((EntityType<? extends Monster>)((EntityType)JEntities.MINI_SENTRY_LORD_TYPE.get()), this.getLevel());
                break;
            }
            case 1: {
                JMonsterEntity jMonsterEntity = new MiniSentryStalker((EntityType<? extends Monster>)((EntityType)JEntities.MINI_SENTRY_STALKER_TYPE.get()), this.getLevel());
                break;
            }
            case 2: {
                JMonsterEntity jMonsterEntity = new MiniSentryWalker((EntityType<? extends Monster>)((EntityType)JEntities.MINI_SENTRY_WALKER_TYPE.get()), this.getLevel());
                break;
            }
            default: {
                JMonsterEntity jMonsterEntity = mob = new MiniSentryLord((EntityType<? extends Monster>)((EntityType)JEntities.MINI_SENTRY_LORD_TYPE.get()), this.getLevel());
            }
        }
        if (!level.isClientSide) {
            mob.setPos((float)x + 0.5f, (float)y + 1.0f, (float)z + 0.5f);
            level.addFreshEntity((Entity)mob);
        }
    }
}

