/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.entity.logic;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.extensions.IOwnedSpawner;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class DarkNotNeededSpawner
extends BaseSpawner {
    private static final Logger LOGGER = LogUtils.getLogger();
    private int spawnDelay = 20;
    private SimpleWeightedRandomList<SpawnData> spawnPotentials = SimpleWeightedRandomList.empty();
    @Nullable
    private SpawnData nextSpawnData;
    private double spin;
    private double oSpin;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;
    private int spawnCount = 4;
    @Nullable
    private Entity displayEntity;
    private int maxNearbyEntities = 6;
    private int requiredPlayerRange = 16;
    private int spawnRange = 4;

    public void setEntityId(EntityType<?> pType, @Nullable Level pLevel, RandomSource pRandom, BlockPos pPos) {
        this.getOrCreateNextSpawnData(pLevel, pRandom, pPos).getEntityToSpawn().putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(pType).toString());
    }

    private boolean isNearPlayer(Level pLevel, BlockPos pPos) {
        return pLevel.hasNearbyAlivePlayer((double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, (double)this.requiredPlayerRange);
    }

    public void clientTick(@NotNull Level pLevel, @NotNull BlockPos pPos) {
        if (!this.isNearPlayer(pLevel, pPos)) {
            this.oSpin = this.spin;
        } else if (this.displayEntity != null) {
            RandomSource randomsource = pLevel.getRandom();
            double d0 = (double)pPos.getX() + randomsource.nextDouble();
            double d1 = (double)pPos.getY() + randomsource.nextDouble();
            double d2 = (double)pPos.getZ() + randomsource.nextDouble();
            pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            pLevel.addParticle((ParticleOptions)ParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0);
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.oSpin = this.spin;
            this.spin = (this.spin + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        }
    }

    public void serverTick(@NotNull ServerLevel pServerLevel, @NotNull BlockPos pPos) {
        if (this.isNearPlayer((Level)pServerLevel, pPos)) {
            if (this.spawnDelay == -1) {
                this.delay((Level)pServerLevel, pPos);
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            } else {
                boolean flag = false;
                RandomSource randomsource = pServerLevel.getRandom();
                SpawnData spawndata = this.getOrCreateNextSpawnData((Level)pServerLevel, randomsource, pPos);
                for (int i = 0; i < this.spawnCount; ++i) {
                    double d2;
                    CompoundTag compoundtag = spawndata.getEntityToSpawn();
                    Optional optional = EntityType.by((CompoundTag)compoundtag);
                    if (optional.isEmpty()) {
                        this.delay((Level)pServerLevel, pPos);
                        return;
                    }
                    ListTag listtag = compoundtag.getList("Pos", 6);
                    int j = listtag.size();
                    double d0 = j >= 1 ? listtag.getDouble(0) : (double)pPos.getX() + (randomsource.nextDouble() - randomsource.nextDouble()) * (double)this.spawnRange + 0.5;
                    double d1 = j >= 2 ? listtag.getDouble(1) : (double)(pPos.getY() + randomsource.nextInt(3) - 1);
                    double d = d2 = j >= 3 ? listtag.getDouble(2) : (double)pPos.getZ() + (randomsource.nextDouble() - randomsource.nextDouble()) * (double)this.spawnRange + 0.5;
                    if (!pServerLevel.noCollision(((EntityType)optional.get()).getSpawnAABB(d0, d1, d2))) continue;
                    BlockPos blockpos = BlockPos.containing((double)d0, (double)d1, (double)d2);
                    if (spawndata.getCustomSpawnRules().isPresent() && !((EntityType)optional.get()).getCategory().isFriendly() && pServerLevel.getDifficulty() == Difficulty.PEACEFUL) continue;
                    Entity entity = EntityType.loadEntityRecursive((CompoundTag)compoundtag, (Level)pServerLevel, p_151310_ -> {
                        p_151310_.moveTo(d0, d1, d2, p_151310_.getYRot(), p_151310_.getXRot());
                        return p_151310_;
                    });
                    if (entity == null) {
                        this.delay((Level)pServerLevel, pPos);
                        return;
                    }
                    int k = pServerLevel.getEntitiesOfClass(entity.getClass(), new AABB((double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ(), (double)(pPos.getX() + 1), (double)(pPos.getY() + 1), (double)(pPos.getZ() + 1)).inflate((double)this.spawnRange)).size();
                    if (k >= this.maxNearbyEntities) {
                        this.delay((Level)pServerLevel, pPos);
                        return;
                    }
                    entity.moveTo(entity.getX(), entity.getY(), entity.getZ(), randomsource.nextFloat() * 360.0f, 0.0f);
                    if (entity instanceof Mob) {
                        Mob mob = (Mob)entity;
                        if (!EventHooks.checkSpawnPositionSpawner((Mob)mob, (ServerLevelAccessor)pServerLevel, (MobSpawnType)MobSpawnType.SPAWNER, (SpawnData)spawndata, (BaseSpawner)this)) continue;
                        boolean flag1 = spawndata.getEntityToSpawn().size() == 1 && spawndata.getEntityToSpawn().contains("id", 8);
                        EventHooks.finalizeMobSpawnSpawner((Mob)mob, (ServerLevelAccessor)pServerLevel, (DifficultyInstance)pServerLevel.getCurrentDifficultyAt(entity.blockPosition()), (MobSpawnType)MobSpawnType.SPAWNER, null, (IOwnedSpawner)this, (boolean)flag1);
                        spawndata.getEquipment().ifPresent(arg_0 -> ((Mob)mob).equip(arg_0));
                    }
                    if (!pServerLevel.tryAddFreshEntityWithPassengers(entity)) {
                        this.delay((Level)pServerLevel, pPos);
                        return;
                    }
                    pServerLevel.levelEvent(2004, pPos, 0);
                    pServerLevel.gameEvent(entity, (Holder)GameEvent.ENTITY_PLACE, blockpos);
                    if (entity instanceof Mob) {
                        ((Mob)entity).spawnAnim();
                    }
                    flag = true;
                }
                if (flag) {
                    this.delay((Level)pServerLevel, pPos);
                }
            }
        }
    }

    private void delay(Level pLevel, BlockPos pPos) {
        RandomSource randomsource = pLevel.random;
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + randomsource.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
        this.spawnPotentials.getRandom(randomsource).ifPresent(p -> this.setNextSpawnData(pLevel, pPos, (SpawnData)p.data()));
        this.broadcastEvent(pLevel, pPos, 1);
    }

    public void load(@Nullable Level pLevel, BlockPos pPos, CompoundTag pTag) {
        boolean flag1;
        this.spawnDelay = pTag.getShort("Delay");
        boolean flag = pTag.contains("SpawnData", 10);
        if (flag) {
            SpawnData spawndata = SpawnData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)pTag.getCompound("SpawnData")).resultOrPartial(p_186391_ -> LOGGER.warn("Invalid SpawnData: {}", p_186391_)).orElseGet(SpawnData::new);
            this.setNextSpawnData(pLevel, pPos, spawndata);
        }
        if (flag1 = pTag.contains("SpawnPotentials", 9)) {
            ListTag listtag = pTag.getList("SpawnPotentials", 10);
            this.spawnPotentials = SpawnData.LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)listtag).resultOrPartial(p_186388_ -> LOGGER.warn("Invalid SpawnPotentials list: {}", p_186388_)).orElseGet(SimpleWeightedRandomList::empty);
        } else {
            this.spawnPotentials = SimpleWeightedRandomList.single((Object)(this.nextSpawnData != null ? this.nextSpawnData : new SpawnData()));
        }
        if (pTag.contains("MinSpawnDelay", 99)) {
            this.minSpawnDelay = pTag.getShort("MinSpawnDelay");
            this.maxSpawnDelay = pTag.getShort("MaxSpawnDelay");
            this.spawnCount = pTag.getShort("SpawnCount");
        }
        if (pTag.contains("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = pTag.getShort("MaxNearbyEntities");
            this.requiredPlayerRange = pTag.getShort("RequiredPlayerRange");
        }
        if (pTag.contains("SpawnRange", 99)) {
            this.spawnRange = pTag.getShort("SpawnRange");
        }
        this.displayEntity = null;
    }

    @NotNull
    public CompoundTag save(CompoundTag pTag) {
        pTag.putShort("Delay", (short)this.spawnDelay);
        pTag.putShort("MinSpawnDelay", (short)this.minSpawnDelay);
        pTag.putShort("MaxSpawnDelay", (short)this.maxSpawnDelay);
        pTag.putShort("SpawnCount", (short)this.spawnCount);
        pTag.putShort("MaxNearbyEntities", (short)this.maxNearbyEntities);
        pTag.putShort("RequiredPlayerRange", (short)this.requiredPlayerRange);
        pTag.putShort("SpawnRange", (short)this.spawnRange);
        if (this.nextSpawnData != null) {
            pTag.put("SpawnData", (Tag)SpawnData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.nextSpawnData).getOrThrow(p_337966_ -> new IllegalStateException("Invalid SpawnData: " + p_337966_)));
        }
        pTag.put("SpawnPotentials", (Tag)SpawnData.LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.spawnPotentials).result().orElseThrow());
        return pTag;
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(Level pLevel, BlockPos pPos) {
        if (this.displayEntity == null) {
            CompoundTag compoundtag = this.getOrCreateNextSpawnData(pLevel, pLevel.getRandom(), pPos).getEntityToSpawn();
            if (!compoundtag.contains("id", 8)) {
                return null;
            }
            this.displayEntity = EntityType.loadEntityRecursive((CompoundTag)compoundtag, (Level)pLevel, Function.identity());
            if (compoundtag.size() != 1 || this.displayEntity instanceof Mob) {
                // empty if block
            }
        }
        return this.displayEntity;
    }

    public boolean onEventTriggered(@NotNull Level pLevel, int pId) {
        if (pId == 1) {
            if (pLevel.isClientSide) {
                this.spawnDelay = this.minSpawnDelay;
            }
            return true;
        }
        return false;
    }

    protected void setNextSpawnData(@Nullable Level pLevel, @NotNull BlockPos pPos, @NotNull SpawnData pNextSpawnData) {
        this.nextSpawnData = pNextSpawnData;
    }

    private SpawnData getOrCreateNextSpawnData(@Nullable Level pLevel, RandomSource pRandom, BlockPos pPos) {
        if (this.nextSpawnData == null) {
            this.setNextSpawnData(pLevel, pPos, this.spawnPotentials.getRandom(pRandom).map(WeightedEntry.Wrapper::data).orElseGet(SpawnData::new));
        }
        return this.nextSpawnData;
    }

    public abstract void broadcastEvent(@NotNull Level var1, @NotNull BlockPos var2, int var3);

    public double getSpin() {
        return this.spin;
    }

    public double getoSpin() {
        return this.oSpin;
    }

    @Nullable
    public Either<BlockEntity, Entity> getOwner() {
        return null;
    }
}

