/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.portal;

import java.util.Optional;
import net.jitl.common.block.portal.logic.DepthsPortal;
import net.jitl.common.block.portal.logic.PortalCoordinatesContainer;
import net.jitl.common.capability.player.Portal;
import net.jitl.common.world.dimension.Dimensions;
import net.jitl.core.init.internal.JBlockProperties;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JDataAttachments;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DepthsPortalBlock
extends Block
implements DepthsPortal {
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);

    public DepthsPortalBlock() {
        super(JBlockProperties.PORTAL);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE;
    }

    @Override
    public Block getPortalBlock() {
        return this;
    }

    @Override
    public Block getPortalFrame() {
        return (Block)JBlocks.DEPTHS_PORTAL_FRAME.get();
    }

    public void animateTick(@NotNull BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        double d0 = (double)pPos.getX() + pRandom.nextDouble();
        double d1 = (double)pPos.getY() + 0.8;
        double d2 = (double)pPos.getZ() + pRandom.nextDouble();
        pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public ItemStack getCloneItemStack(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return ItemStack.EMPTY;
    }

    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entity) {
        if (entity.canUsePortal(false)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                Portal portal = (Portal)player.getData(JDataAttachments.PORTAL_OVERLAY);
                portal.setInPortal(this, true);
                int cooldownTime = portal.getPortalTimer();
                assert (player.portalProcess != null);
                entity.setAsInsidePortal((net.minecraft.world.level.block.Portal)this, pos);
            } else {
                entity.setAsInsidePortal((net.minecraft.world.level.block.Portal)this, pos);
            }
        }
    }

    @Nullable
    public DimensionTransition getPortalDestination(ServerLevel level, Entity entity, BlockPos pos) {
        PortalCoordinatesContainer portalCoordinatesContainer;
        if (!(entity instanceof ServerPlayer)) {
            return null;
        }
        ResourceKey currentDimension = level.dimension();
        ResourceKey<Level> portalTargetDimension = Dimensions.DEPTHS;
        MinecraftServer server = level.getServer();
        if (entity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)entity;
            portalCoordinatesContainer = ((Portal)pl.getData(JDataAttachments.PORTAL_OVERLAY)).getPortalReturnLocation((ResourceKey<Level>)currentDimension);
        } else {
            portalCoordinatesContainer = null;
        }
        Optional<Object> existingLink = Optional.ofNullable(portalCoordinatesContainer);
        ServerLevel targetLevel = existingLink.map(link -> server.getLevel(currentDimension != portalTargetDimension ? portalTargetDimension : link.fromDim())).orElseGet(() -> server.getLevel(currentDimension == portalTargetDimension ? Level.OVERWORLD : portalTargetDimension));
        if (targetLevel == null) {
            if (currentDimension == Level.OVERWORLD) {
                return null;
            }
            targetLevel = server.overworld();
        }
        return DepthsPortal.getTransitionForLevel(targetLevel, entity, Optional.of(pos), DepthsPortal.makeSafeCoords((Level)level, (Level)targetLevel, entity.position()), this, existingLink);
    }

    public boolean canBeReplaced(@NotNull BlockState pState, @NotNull Fluid pFluid) {
        return false;
    }
}

