/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.portal;

import java.util.Optional;
import java.util.function.Supplier;
import net.jitl.common.block.portal.logic.JPortal;
import net.jitl.common.block.portal.logic.PortalCoordinatesContainer;
import net.jitl.common.capability.player.Portal;
import net.jitl.common.entity.EntityUtil;
import net.jitl.core.init.internal.JBlockProperties;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JDataAttachments;
import net.jitl.core.init.internal.JParticleManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBasePortalBlock
extends Block
implements JPortal {
    protected static final VoxelShape X_AABB = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AABB = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private final ResourceKey<Level> dimensionID;
    private final Supplier<Block> frame;

    public JBasePortalBlock(ResourceKey<Level> dimID, Supplier<Block> frame) {
        super(JBlockProperties.PORTAL);
        this.dimensionID = dimID;
        this.frame = frame;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)Direction.Axis.X));
    }

    @Override
    public JBasePortalBlock getPortalBlock() {
        return this;
    }

    @Override
    public Block getPortalFrame() {
        return this.frame.get();
    }

    public ResourceKey<Level> getDimension() {
        return this.dimensionID;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS) == Direction.Axis.Z) {
            return Z_AABB;
        }
        return X_AABB;
    }

    public boolean skipRendering(BlockState state, BlockState adjacent, Direction side) {
        if (adjacent.getBlock() == this) {
            switch ((Direction.Axis)state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
                case X: {
                    Direction.Axis axis = (Direction.Axis)adjacent.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
                    if (axis != Direction.Axis.X) break;
                    return true;
                }
                case Z: {
                    Direction.Axis axis = (Direction.Axis)adjacent.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
                    if (axis != Direction.Axis.Z) break;
                    return true;
                }
            }
        }
        return false;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
                    case Z: {
                        yield (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_AXIS});
    }

    public void attack(BlockState state, Level world, BlockPos pos, Player player) {
        if (world.isEmptyBlock(pos.above()) || world.isEmptyBlock(pos.below())) {
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            return;
        }
        switch ((Direction.Axis)world.getBlockState(pos).getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
            case Z: {
                if (!world.isEmptyBlock(pos.east()) && !world.isEmptyBlock(pos.west())) break;
                world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                break;
            }
            case X: {
                if (!world.isEmptyBlock(pos.north()) && !world.isEmptyBlock(pos.south())) break;
                world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            }
        }
    }

    private boolean isCompatibleNeighbour(Level world, BlockPos pos) {
        BlockState block = world.getBlockState(pos);
        return block.getBlock() == this || !block.isAir();
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        Direction.Axis facing = (Direction.Axis)state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
        switch (facing) {
            case Z: {
                if (this.isCompatibleNeighbour(world, pos.above()) && this.isCompatibleNeighbour(world, pos.below()) && this.isCompatibleNeighbour(world, pos.east()) && this.isCompatibleNeighbour(world, pos.west())) break;
                world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                break;
            }
            case X: {
                if (this.isCompatibleNeighbour(world, pos.above()) && this.isCompatibleNeighbour(world, pos.below()) && this.isCompatibleNeighbour(world, pos.north()) && this.isCompatibleNeighbour(world, pos.south())) break;
                world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            }
        }
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        SimpleParticleType particle = null;
        SimpleParticleType particle2 = null;
        if (this == JBlocks.EUCA_PORTAL.get()) {
            particle = (SimpleParticleType)JParticleManager.GOLDITE_FLOWER.get();
        }
        if (this == JBlocks.FROZEN_PORTAL.get()) {
            particle = (SimpleParticleType)JParticleManager.SNOWFLAKE.get();
        }
        if (this == JBlocks.BOIL_PORTAL.get()) {
            particle = (SimpleParticleType)JParticleManager.FLAME_POLLEN.get();
            particle2 = (SimpleParticleType)JParticleManager.SULPHUR.get();
        }
        if (this == JBlocks.TERRANIAN_PORTAL.get()) {
            particle = (SimpleParticleType)JParticleManager.TERRANIA_PORTAL.get();
        }
        if (this == JBlocks.CLOUDIA_PORTAL.get()) {
            particle = (SimpleParticleType)JParticleManager.CLOUDIA_PORTAL.get();
        }
        for (int i = 0; i < 3; ++i) {
            double d0 = (double)pos.getX() + random.nextDouble();
            double d1 = (double)pos.getY() + random.nextDouble();
            double d2 = (double)pos.getZ() + random.nextDouble();
            double d3 = ((double)random.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)random.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)random.nextFloat() - 0.5) * 0.5;
            int j = random.nextInt(2) * 2 - 1;
            if (!level.getBlockState(pos.west()).is((Block)this) && !level.getBlockState(pos.east()).is((Block)this)) {
                d0 = (double)pos.getX() + 0.5 + 0.25 * (double)j;
                d3 = random.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.getZ() + 0.5 + 0.25 * (double)j;
                d5 = random.nextFloat() * 2.0f * (float)j;
            }
            if (particle != null) {
                level.addParticle((ParticleOptions)particle, d0, d1, d2, d3, d4, d5);
            }
            if (particle2 == null) continue;
            level.addParticle((ParticleOptions)particle2, d0, d1, d2, d3, d4, d5);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)EntityUtil.getDirectionFacing((Entity)context.getPlayer(), true).getAxis());
    }

    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entity) {
        if (entity.canUsePortal(false)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                Portal portal = (Portal)player.getData(JDataAttachments.PORTAL_OVERLAY);
                portal.setInPortal(this, true);
                int cooldownTime = portal.getPortalTimer();
                assert (player.portalProcess != null);
                entity.setAsInsidePortal((net.minecraft.world.level.block.Portal)this, pos);
            } else {
                entity.setAsInsidePortal((net.minecraft.world.level.block.Portal)this, pos);
            }
        }
    }

    @Nullable
    public DimensionTransition getPortalDestination(ServerLevel level, Entity entity, BlockPos pos) {
        PortalCoordinatesContainer portalCoordinatesContainer;
        if (!(entity instanceof ServerPlayer)) {
            return null;
        }
        ResourceKey currentDimension = level.dimension();
        ResourceKey<Level> portalTargetDimension = this.getDimension();
        MinecraftServer server = level.getServer();
        if (entity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)entity;
            portalCoordinatesContainer = ((Portal)pl.getData(JDataAttachments.PORTAL_OVERLAY)).getPortalReturnLocation((ResourceKey<Level>)currentDimension);
        } else {
            portalCoordinatesContainer = null;
        }
        Optional<Object> existingLink = Optional.ofNullable(portalCoordinatesContainer);
        ServerLevel targetLevel = existingLink.map(link -> server.getLevel(currentDimension != portalTargetDimension ? portalTargetDimension : link.fromDim())).orElseGet(() -> server.getLevel(currentDimension == portalTargetDimension ? Level.OVERWORLD : portalTargetDimension));
        if (targetLevel == null) {
            if (currentDimension == Level.OVERWORLD) {
                return null;
            }
            targetLevel = server.overworld();
        }
        return JPortal.getTransitionForLevel(targetLevel, entity, Optional.of(pos), JPortal.makeSafeCoords((Level)level, (Level)targetLevel, entity.position()), this, existingLink);
    }

    public boolean makePortal(LevelAccessor worldIn, BlockPos pos) {
        return false;
    }
}

