/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.portal.logic;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.jitl.common.block.portal.DepthsPortalFrameBlock;
import net.jitl.common.block.portal.JBasePortalBlock;
import net.jitl.common.block.portal.logic.PortalCoordinatesContainer;
import net.jitl.common.capability.player.Portal;
import net.jitl.common.world.WorldUtil;
import net.jitl.common.world.dimension.Dimensions;
import net.jitl.core.config.JCommonConfig;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JDataAttachments;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;

public interface CorbaPortal
extends net.minecraft.world.level.block.Portal {
    public static final IdentityHashMap<ResourceKey<Level>, List<BlockPos>> TRANSIENT_PORTAL_CACHE = new IdentityHashMap();

    public Block getPortalBlock();

    public Block getPortalFrame();

    default public DimensionTransition.PostDimensionTransition playTransitSound(Entity entity) {
        return DimensionTransition.PLAY_PORTAL_SOUND;
    }

    public static BlockPos makeSafeCoords(Level fromLevel, Level toLevel, Vec3 pos) {
        WorldBorder border = toLevel.getWorldBorder();
        double relativeScale = DimensionType.getTeleportationScale((DimensionType)fromLevel.dimensionType(), (DimensionType)toLevel.dimensionType());
        return border.clampToBounds(pos.x * relativeScale, pos.y, pos.z * relativeScale);
    }

    public static DimensionTransition getTransitionForLevel(ServerLevel destination, Entity entity, Block jPortalBlock) {
        PortalCoordinatesContainer portalCoordinatesContainer;
        Optional<BlockPos> optional = Optional.empty();
        BlockPos blockPos = entity.blockPosition();
        CorbaPortal corbaPortal = (CorbaPortal)jPortalBlock;
        if (entity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)entity;
            portalCoordinatesContainer = ((Portal)pl.getData(JDataAttachments.PORTAL_OVERLAY)).getPortalReturnLocation((ResourceKey<Level>)entity.level().dimension());
        } else {
            portalCoordinatesContainer = null;
        }
        return CorbaPortal.getTransitionForLevel(destination, entity, optional, blockPos, corbaPortal, Optional.ofNullable(portalCoordinatesContainer));
    }

    public static DimensionTransition getTransitionForLevel(ServerLevel destination, Entity entity, Optional<BlockPos> fromPortal, BlockPos safeCoords, CorbaPortal portal, Optional<PortalCoordinatesContainer> existingLink) {
        ServerLevel fromLevel = (ServerLevel)entity.level();
        BlockPos portalPos = CorbaPortal.getOrCreatePortalLocation(destination, fromLevel, entity, safeCoords, portal, existingLink);
        fromPortal.ifPresent(portalBlock -> {
            if (entity instanceof ServerPlayer) {
                ServerPlayer pl = (ServerPlayer)entity;
                CorbaPortal.updatePlayerLink(pl, portalBlock, (ResourceKey<Level>)fromLevel.dimension(), (ResourceKey<Level>)destination.dimension());
            }
        });
        return new DimensionTransition(destination, Vec3.atCenterOf((Vec3i)portalPos), entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), portal.playTransitSound(entity).then(DimensionTransition.PLACE_PORTAL_TICKET));
    }

    public static BlockPos getOrCreatePortalLocation(ServerLevel destination, ServerLevel fromLevel, Entity entity, BlockPos safeCoords, CorbaPortal portal, Optional<PortalCoordinatesContainer> existingLink) {
        BlockPos portalPos;
        if (entity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)entity;
            v0 = existingLink.filter(link -> link.fromDim() == destination.dimension()).map(link -> portal.retrieveExistingLinkExit(pl, pl.serverLevel(), destination, (PortalCoordinatesContainer)link)).orElse(null);
        } else {
            v0 = portalPos = null;
        }
        if (fromLevel.getBlockState(entity.blockPosition()).getBlock() instanceof JBasePortalBlock) {
            CorbaPortal.updateLocalCache((Level)fromLevel, entity.blockPosition());
        }
        if (portalPos == null) {
            portalPos = portal.findExistingPortal((Level)destination, entity, safeCoords);
        }
        if (portalPos == null) {
            portalPos = portal.findSuitablePortalLocation((Level)destination, entity, safeCoords);
            portalPos = portal.createPortalFrameAndSpace((Level)destination, entity, portalPos);
        }
        CorbaPortal.updateLocalCache((Level)destination, portalPos);
        return portalPos;
    }

    public static void updatePlayerLink(ServerPlayer pl, BlockPos fromPortalBlockPos, ResourceKey<Level> fromDim, ResourceKey<Level> destinationDim) {
        PortalCoordinatesContainer returnPortalLoc;
        Portal plData = (Portal)pl.getData(JDataAttachments.PORTAL_OVERLAY);
        PortalCoordinatesContainer portalLoc = plData.getPortalReturnLocation(destinationDim);
        if (portalLoc != null && (returnPortalLoc = plData.getPortalReturnLocation(fromDim)) != null && returnPortalLoc.fromDim() == destinationDim) {
            return;
        }
        if (portalLoc == null || fromDim == portalLoc.fromDim() || pl.distanceToSqr(Vec3.atLowerCornerOf((Vec3i)portalLoc.portalPos())) > (double)((Integer)JCommonConfig.PORTAL_SEARCH_RADIUS.get() * (Integer)JCommonConfig.PORTAL_SEARCH_RADIUS.get())) {
            plData.setPortalReturnLocation(destinationDim, new PortalCoordinatesContainer(fromDim, fromPortalBlockPos));
        }
    }

    @Nullable
    public static BlockPos getLocalCachedPos(Level level, BlockPos pos, Block portalBlock) {
        List<BlockPos> localPortalCache = TRANSIENT_PORTAL_CACHE.get(level.dimension());
        if (localPortalCache == null || localPortalCache.isEmpty()) {
            return null;
        }
        int range = JCommonConfig.PORTAL_SEARCH_RADIUS.getAsInt();
        BlockPos closest = null;
        double closestDistSqr = Double.MAX_VALUE;
        Iterator<BlockPos> positions = localPortalCache.iterator();
        while (positions.hasNext()) {
            BlockPos nextPos = positions.next();
            double distSqr = nextPos.distSqr((Vec3i)pos);
            if (!(distSqr <= (double)(range * range)) || !(distSqr < closestDistSqr)) continue;
            if (!level.getBlockState(nextPos).is(portalBlock)) {
                positions.remove();
                continue;
            }
            closest = nextPos;
            closestDistSqr = distSqr;
        }
        return closest;
    }

    public static BlockPos updateLocalCache(Level level, BlockPos pos) {
        TRANSIENT_PORTAL_CACHE.computeIfAbsent((ResourceKey<Level>)level.dimension(), key -> new ObjectArrayList()).add(pos.immutable());
        return pos;
    }

    @Nullable
    default public BlockPos retrieveExistingLinkExit(ServerPlayer player, ServerLevel currentWorld, ServerLevel destWorld, PortalCoordinatesContainer existingLink) {
        Portal plData = (Portal)player.getData(JDataAttachments.PORTAL_OVERLAY);
        BlockPos locPos = existingLink.portalPos();
        BlockState state = destWorld.getBlockState(locPos);
        if (state.is(this.getPortalBlock())) {
            return locPos;
        }
        if (!(state.getBlock() instanceof JBasePortalBlock)) {
            plData.removePortalReturnLocation((ResourceKey<Level>)currentWorld.dimension());
        }
        return null;
    }

    default public BlockPos findExistingPortal(Level targetLevel, Entity entity, BlockPos originPos) {
        BlockPos cachedPos = CorbaPortal.getLocalCachedPos(targetLevel, originPos, this.getPortalBlock());
        if (cachedPos != null) {
            return cachedPos;
        }
        Block portalBlock = this.getPortalBlock();
        int searchRadius = (Integer)JCommonConfig.PORTAL_SEARCH_RADIUS.get();
        int worldHeight = targetLevel.getMaxBuildHeight();
        int worldFloor = targetLevel.getMinBuildHeight();
        int posX = Mth.floor((float)originPos.getX());
        int posY = originPos.getY() >= worldHeight ? 65 : Mth.floor((float)originPos.getY());
        int posZ = Mth.floor((float)originPos.getZ());
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(posX, posY, posZ);
        try (BulkSectionAccess sectionAccess = new BulkSectionAccess((LevelAccessor)targetLevel);){
            int z;
            int x;
            if (sectionAccess.getBlockState((BlockPos)checkPos).is(portalBlock)) {
                while (sectionAccess.getBlockState((BlockPos)checkPos.move(Direction.DOWN)).is(portalBlock)) {
                }
                BlockPos blockPos = CorbaPortal.updateLocalCache(targetLevel, (BlockPos)checkPos);
                return blockPos;
            }
            for (int radius = 1; radius <= searchRadius; ++radius) {
                for (int y = posY - radius; y <= posY + radius; y += radius * 2) {
                    if (y < worldFloor || y >= worldHeight) continue;
                    int xNeg = -1;
                    for (int x2 = 0; x2 <= radius; ++x2) {
                        int x22 = posX + x2 * xNeg;
                        if (xNeg == 1 && x2 != 0) {
                            --x2;
                        }
                        xNeg *= -1;
                        int zNeg = -1;
                        for (int z2 = 0; z2 <= radius; ++z2) {
                            int z22 = posZ + z2 * zNeg;
                            if (zNeg == 1 && z2 != 0) {
                                --z2;
                            }
                            zNeg *= -1;
                            if (!sectionAccess.getBlockState((BlockPos)checkPos.set(x22, y, z22)).is(portalBlock)) continue;
                            while (sectionAccess.getBlockState((BlockPos)checkPos.move(Direction.DOWN)).is(portalBlock)) {
                            }
                            BlockPos blockPos = CorbaPortal.updateLocalCache(targetLevel, checkPos.above());
                            return blockPos;
                        }
                    }
                }
                int yNeg = -1;
                for (int y = 0; y <= radius - 1; ++y) {
                    int y2 = posY + y * yNeg;
                    if (y2 < worldFloor || y2 >= worldHeight) continue;
                    if (yNeg == 1 && y != 0) {
                        --y;
                    }
                    yNeg *= -1;
                    int zNeg = -1;
                    for (int z3 = 0; z3 <= radius; ++z3) {
                        int z2 = posZ + z3 * zNeg;
                        if (zNeg == 1 && z3 != 0) {
                            --z3;
                        }
                        zNeg *= -1;
                        for (int x3 = -radius; x3 <= radius; x3 += radius * 2) {
                            int x2 = posX + x3;
                            if (!sectionAccess.getBlockState((BlockPos)checkPos.set(x2, y2, z2)).is(portalBlock)) continue;
                            while (sectionAccess.getBlockState((BlockPos)checkPos.move(Direction.DOWN)).is(portalBlock)) {
                            }
                            BlockPos blockPos = CorbaPortal.updateLocalCache(targetLevel, checkPos.above());
                            return blockPos;
                        }
                    }
                    int xNeg = 1;
                    for (int x4 = 1; x4 <= radius - 1; ++x4) {
                        int x2 = posX + x4 * xNeg;
                        if (xNeg == 1 && x4 != 0) {
                            --x4;
                        }
                        xNeg *= -1;
                        for (int z4 = -radius; z4 <= radius; z4 += radius * 2) {
                            int z2 = posZ + z4;
                            if (!sectionAccess.getBlockState((BlockPos)checkPos.set(x2, y2, z2)).is(portalBlock)) continue;
                            while (sectionAccess.getBlockState((BlockPos)checkPos.move(Direction.DOWN)).is(portalBlock)) {
                            }
                            BlockPos blockPos = CorbaPortal.updateLocalCache(targetLevel, checkPos.above());
                            return blockPos;
                        }
                    }
                }
            }
            for (x = posX - searchRadius; x <= posX + searchRadius; ++x) {
                for (z = posZ - searchRadius; z <= posZ + searchRadius; ++z) {
                    checkPos.set(x, posY - searchRadius, z);
                    while (!sectionAccess.getBlockState((BlockPos)checkPos.move(Direction.DOWN)).is(portalBlock) && checkPos.getY() >= worldFloor) {
                    }
                    if (!sectionAccess.getBlockState((BlockPos)checkPos).is(portalBlock)) continue;
                    while (sectionAccess.getBlockState((BlockPos)checkPos.move(Direction.DOWN)).is(portalBlock)) {
                    }
                    BlockPos blockPos = checkPos.above(2).immutable();
                    return blockPos;
                }
            }
            for (x = posX - searchRadius; x <= posX + searchRadius; ++x) {
                for (z = posZ - searchRadius; z <= posZ + searchRadius; ++z) {
                    checkPos.set(x, posY + searchRadius, z);
                    while (!sectionAccess.getBlockState((BlockPos)checkPos.move(Direction.UP)).is(portalBlock) && checkPos.getY() < worldHeight) {
                    }
                    if (!sectionAccess.getBlockState((BlockPos)checkPos).is(portalBlock)) continue;
                    BlockPos blockPos = checkPos.above().immutable();
                    return blockPos;
                }
            }
        }
        return null;
    }

    default public BlockPos findSuitablePortalLocation(Level level, Entity entity, BlockPos originPos) {
        int searchRadius = (Integer)JCommonConfig.PORTAL_SEARCH_RADIUS.get();
        int worldHeight = level.getMaxBuildHeight();
        int worldFloor = level.getMinBuildHeight();
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        int posX = Mth.floor((float)originPos.getX());
        int posY = originPos.getY() >= worldHeight ? 64 : Mth.floor((float)originPos.getY());
        int posZ = Mth.floor((float)originPos.getZ());
        BlockPos fallbackPos = null;
        boolean isCleanSpawn = true;
        try (BulkSectionAccess sectionAccess = new BulkSectionAccess((LevelAccessor)level);){
            int y2;
            int z2;
            int x25;
            int y;
            int z;
            int x3;
            for (x3 = posX - 2; x3 <= posX + 2 && isCleanSpawn; ++x3) {
                for (z = posZ - 2; z <= posZ + 2 && isCleanSpawn; ++z) {
                    for (y = posY + 1; y <= posY + 6 && isCleanSpawn; ++y) {
                        if (y < worldHeight && sectionAccess.getBlockState((BlockPos)checkPos.set(x3, y, z)).isAir()) continue;
                        isCleanSpawn = false;
                    }
                }
            }
            if (isCleanSpawn) {
                if (!sectionAccess.getBlockState((BlockPos)checkPos.set(posX, posY, posZ)).isAir()) {
                    BlockPos x3 = checkPos.set(posX, posY + 2, posZ).immutable();
                    return x3;
                }
                fallbackPos = checkPos.set(posX, posY + 2, posZ).immutable();
            }
            for (int radius = 1; radius <= searchRadius; ++radius) {
                for (int y3 = posY - radius; y3 <= posY + radius; y3 += radius * 2) {
                    if (y3 < worldFloor || y3 >= worldHeight - 6) continue;
                    int xNeg = -1;
                    for (int x4 = 0; x4 <= radius; ++x4) {
                        int x22 = posX + x4 * xNeg;
                        if (xNeg == 1 && x4 != 0) {
                            --x4;
                        }
                        xNeg *= -1;
                        int zNeg = -1;
                        for (int z3 = 0; z3 <= radius; ++z3) {
                            int y32;
                            int z32;
                            int x32;
                            int z22 = posZ + z3 * zNeg;
                            if (zNeg == 1 && z3 != 0) {
                                --z3;
                            }
                            zNeg *= -1;
                            if (!sectionAccess.getBlockState((BlockPos)checkPos.set(x22, y3, z22)).isAir()) {
                                isCleanSpawn = true;
                                for (x32 = x22 - 2; x32 <= x22 + 2 && isCleanSpawn; ++x32) {
                                    for (z32 = z22 - 2; z32 <= z22 + 2 && isCleanSpawn; ++z32) {
                                        for (y32 = y3 + 1; y32 <= y3 + 6 && isCleanSpawn; ++y32) {
                                            if (sectionAccess.getBlockState((BlockPos)checkPos.set(x32, y32, z32)).isAir()) continue;
                                            isCleanSpawn = false;
                                        }
                                    }
                                }
                                if (!isCleanSpawn) continue;
                                BlockPos x32 = checkPos.set(x22, y3 + 2, z22).immutable();
                                return x32;
                            }
                            if (fallbackPos != null) continue;
                            isCleanSpawn = true;
                            for (x32 = x22 - 2; x32 <= x22 + 2 && isCleanSpawn; ++x32) {
                                for (z32 = z22 - 2; z32 <= z22 + 2 && isCleanSpawn; ++z32) {
                                    for (y32 = y3 + 1; y32 <= y3 + 6 && isCleanSpawn; ++y32) {
                                        if (sectionAccess.getBlockState((BlockPos)checkPos.set(x32, y32, z32)).isAir()) continue;
                                        isCleanSpawn = false;
                                    }
                                }
                            }
                            if (!isCleanSpawn) continue;
                            fallbackPos = checkPos.set(x22, y3 + 2, z22).immutable();
                        }
                    }
                }
                int yNeg = -1;
                for (y = 0; y <= radius - 1; ++y) {
                    int y22 = posY + y * yNeg;
                    if (y22 < 0 || y22 >= worldHeight - 6) continue;
                    if (yNeg == 1 && y != 0) {
                        --y;
                    }
                    yNeg *= -1;
                    int zNeg = -1;
                    for (int z4 = 0; z4 <= radius; ++z4) {
                        int z23 = posZ + z4 * zNeg;
                        if (zNeg == 1 && z4 != 0) {
                            --z4;
                        }
                        zNeg *= -1;
                        for (int x5 = -radius; x5 <= radius; x5 += radius * 2) {
                            int y3;
                            int z3;
                            int x33;
                            int x23 = posX + x5;
                            if (!sectionAccess.getBlockState((BlockPos)checkPos.set(x23, y22, z23)).isAir()) {
                                isCleanSpawn = true;
                                for (x33 = x23 - 2; x33 <= x23 + 2 && isCleanSpawn; ++x33) {
                                    for (z3 = z23 - 2; z3 <= z23 + 2 && isCleanSpawn; ++z3) {
                                        for (y3 = y22 + 1; y3 <= y22 + 6 && isCleanSpawn; ++y3) {
                                            if (sectionAccess.getBlockState((BlockPos)checkPos.set(x33, y3, z3)).isAir()) continue;
                                            isCleanSpawn = false;
                                        }
                                    }
                                }
                                if (!isCleanSpawn) continue;
                                BlockPos x33 = checkPos.set(x23, y22 + 2, z23).immutable();
                                return x33;
                            }
                            if (fallbackPos != null) continue;
                            isCleanSpawn = true;
                            for (x33 = x23 - 2; x33 <= x23 + 2 && isCleanSpawn; ++x33) {
                                for (z3 = z23 - 2; z3 <= z23 + 2 && isCleanSpawn; ++z3) {
                                    for (y3 = y22 + 1; y3 <= y22 + 6 && isCleanSpawn; ++y3) {
                                        if (sectionAccess.getBlockState((BlockPos)checkPos.set(x33, y3, z3)).isAir()) continue;
                                        isCleanSpawn = false;
                                    }
                                }
                            }
                            if (!isCleanSpawn) continue;
                            fallbackPos = checkPos.set(x23, y22 + 2, z23).immutable();
                        }
                    }
                    int xNeg = 1;
                    for (int x6 = 1; x6 <= radius - 1; ++x6) {
                        int x24 = posX + x6 * xNeg;
                        if (xNeg == 1 && x6 != 0) {
                            --x6;
                        }
                        xNeg *= -1;
                        for (int z5 = -radius; z5 <= radius; z5 += radius * 2) {
                            int y3;
                            int z3;
                            int x34;
                            int z24 = posZ + z5;
                            if (!sectionAccess.getBlockState((BlockPos)checkPos.set(x24, y22, z24)).isAir()) {
                                isCleanSpawn = true;
                                for (x34 = x24 - 2; x34 <= x24 + 2 && isCleanSpawn; ++x34) {
                                    for (z3 = z24 - 2; z3 <= z24 + 2 && isCleanSpawn; ++z3) {
                                        for (y3 = y22 + 1; y3 <= y22 + 6 && isCleanSpawn; ++y3) {
                                            if (sectionAccess.getBlockState((BlockPos)checkPos.set(x34, y3, z3)).isAir()) continue;
                                            isCleanSpawn = false;
                                        }
                                    }
                                }
                                if (!isCleanSpawn) continue;
                                BlockPos x34 = checkPos.set(x24, y22 + 2, z24).immutable();
                                return x34;
                            }
                            if (fallbackPos != null) continue;
                            isCleanSpawn = true;
                            for (x34 = x24 - 2; x34 <= x24 + 2 && isCleanSpawn; ++x34) {
                                for (z3 = z24 - 2; z3 <= z24 + 2 && isCleanSpawn; ++z3) {
                                    for (y3 = y22 + 1; y3 <= y22 + 6 && isCleanSpawn; ++y3) {
                                        if (sectionAccess.getBlockState((BlockPos)checkPos.set(x34, y3, z3)).isAir()) continue;
                                        isCleanSpawn = false;
                                    }
                                }
                            }
                            if (!isCleanSpawn) continue;
                            fallbackPos = checkPos.set(x24, y22 + 2, z24).immutable();
                        }
                    }
                }
            }
            for (x3 = posX - searchRadius; x3 <= posX + searchRadius; ++x3) {
                for (z = posZ - searchRadius; z <= posZ + searchRadius; ++z) {
                    checkPos.set(x3, posY - searchRadius, z);
                    while (sectionAccess.getBlockState((BlockPos)checkPos.move(Direction.DOWN)).isAir() && checkPos.getY() >= 0) {
                    }
                    y = checkPos.getY();
                    isCleanSpawn = true;
                    for (x25 = x3 - 2; x25 <= x3 + 2 && isCleanSpawn; ++x25) {
                        for (z2 = z - 2; z2 <= z + 2 && isCleanSpawn; ++z2) {
                            for (y2 = y + 1; y2 <= y + 6 && isCleanSpawn; ++y2) {
                                if (sectionAccess.getBlockState((BlockPos)checkPos.set(x25, y2, z2)).isAir() && y2 < worldHeight - 6) continue;
                                isCleanSpawn = false;
                            }
                        }
                    }
                    if (!isCleanSpawn || y < 0) continue;
                    BlockPos x25 = checkPos.set(x3, y + 2, z).immutable();
                    return x25;
                }
            }
            for (x3 = posX - searchRadius; x3 <= posX + searchRadius; ++x3) {
                for (z = posZ - searchRadius; z <= posZ + searchRadius; ++z) {
                    checkPos.set(x3, worldHeight - 7, z);
                    while (sectionAccess.getBlockState((BlockPos)checkPos.move(Direction.DOWN)).isAir() && checkPos.getY() >= posY + searchRadius) {
                    }
                    y = checkPos.getY();
                    isCleanSpawn = true;
                    for (x25 = x3 - 2; x25 <= x3 + 2 && isCleanSpawn; ++x25) {
                        for (z2 = z - 2; z2 <= z + 2 && isCleanSpawn; ++z2) {
                            for (y2 = y + 1; y2 <= y + 6 && isCleanSpawn; ++y2) {
                                if (sectionAccess.getBlockState((BlockPos)checkPos.set(x25, y2, z2)).isAir()) continue;
                                isCleanSpawn = false;
                            }
                        }
                    }
                    if (!isCleanSpawn) continue;
                    BlockPos blockPos = checkPos.set(x3, y + 2, z).immutable();
                    return blockPos;
                }
            }
        }
        if (fallbackPos != null) {
            return fallbackPos;
        }
        return BlockPos.containing((double)originPos.getX(), (double)Math.clamp((long)(originPos.getY() + 2), worldFloor + 1, worldHeight - 10), (double)originPos.getZ());
    }

    default public BlockPos createPortalFrameAndSpace(Level level, Entity entity, BlockPos pos) {
        int z;
        int x;
        if (WorldUtil.isWorld(level, Dimensions.OVERWORLD)) {
            return pos;
        }
        BlockPos returnPos = pos;
        BlockState border = (BlockState)this.getPortalFrame().defaultBlockState().setValue((Property)DepthsPortalFrameBlock.HAS_EYE, (Comparable)Boolean.valueOf(true));
        BlockState portal = this.getPortalBlock().defaultBlockState();
        for (x = -2; x < 3; ++x) {
            for (z = -2; z < 3; ++z) {
                if (Math.abs(x) < 2 && Math.abs(z) < 2) {
                    level.setBlock(pos.offset(x, 0, z), portal, 3);
                    continue;
                }
                if (Math.abs(z) < 2) {
                    if (x == -2) {
                        level.setBlock(pos.offset(x, 0, z), (BlockState)border.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.EAST), 3);
                        continue;
                    }
                    if (x != 2) continue;
                    level.setBlock(pos.offset(x, 0, z), (BlockState)border.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.WEST), 3);
                    continue;
                }
                if (Math.abs(x) >= 2) continue;
                if (z == -2) {
                    level.setBlock(pos.offset(x, 0, z), (BlockState)border.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.SOUTH), 3);
                    continue;
                }
                level.setBlock(pos.offset(x, 0, z), (BlockState)border.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH), 3);
            }
        }
        for (x = -4; x < 5; ++x) {
            for (z = -4; z < 5; ++z) {
                level.setBlock(pos.offset(x, -1, z), ((Block)JBlocks.CORBA_GRASS.get()).defaultBlockState(), 3);
            }
        }
        for (x = -2; x < 3; ++x) {
            for (z = -2; z < 3; ++z) {
                level.setBlock(pos.offset(x, 1, z), Blocks.AIR.defaultBlockState(), 3);
                level.setBlock(pos.offset(x, 2, z), Blocks.AIR.defaultBlockState(), 3);
            }
        }
        return returnPos;
    }
}

