/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.capability.essence;

import java.util.Objects;
import net.jitl.core.data.JNetworkRegistry;
import net.jitl.core.init.internal.JAttributes;
import net.jitl.core.init.network.PacketEssenceBar;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.UnknownNullability;

public class PlayerEssence
implements INBTSerializable<CompoundTag> {
    private float currentEssence;
    private float burnoutTime;
    private int timeout;

    public void copyFrom(PlayerEssence source) {
        this.currentEssence = source.currentEssence;
    }

    public float getCurrentEssence() {
        return this.currentEssence;
    }

    public static float getMaxEssence(Player player) {
        return (float)Objects.requireNonNull(player.getAttribute(JAttributes.MAX_ESSENCE)).getValue();
    }

    public void setBurnout(float value) {
        this.burnoutTime = Math.max(value, 0.0f);
    }

    public void setTimeout(int value) {
        this.timeout = value;
    }

    public float getBurnout() {
        return this.burnoutTime;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setEssence(float value) {
        if (this.getCurrentEssence() != value) {
            this.currentEssence = value;
        }
    }

    public boolean isRegenReady() {
        if (this.getTimeout() <= 0) {
            return this.getBurnout() <= 0.0f;
        }
        this.setTimeout(this.getTimeout() - 1);
        return false;
    }

    public void addEssence(Player player, float add) {
        this.setEssence(Math.min(this.getCurrentEssence() + add, PlayerEssence.getMaxEssence(player)));
    }

    public boolean consumeEssence(Player player, float price) {
        if (!player.isCreative()) {
            if (this.hasEssence(price)) {
                this.setEssence(this.getCurrentEssence() - price);
                this.setTimeout(15);
                return true;
            }
            float attributeValue = (float)Objects.requireNonNull(player.getAttribute(JAttributes.ESSENCE_BURNOUT)).getValue();
            this.setBurnout(Math.min(this.getBurnout() + attributeValue, attributeValue * 5.0f));
            return false;
        }
        return true;
    }

    public boolean hasEssence(float price) {
        return this.getCurrentEssence() >= price;
    }

    public boolean checkEssenceEitherSide(boolean client, Player player, float price) {
        if (client) {
            return player.isCreative() || this.hasEssence(price);
        }
        return this.consumeEssence(player, price);
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putFloat("essence", this.currentEssence);
        nbt.putFloat("burnoutTime", this.burnoutTime);
        nbt.putInt("timeout", this.timeout);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.currentEssence = nbt.getFloat("essence");
        this.burnoutTime = nbt.getFloat("burnoutTime");
        this.timeout = nbt.getInt("timeout");
    }

    public void sendPacket(Player player) {
        if (player != null && player instanceof ServerPlayer) {
            JNetworkRegistry.sendToPlayer((ServerPlayer)player, new PacketEssenceBar(this.getCurrentEssence(), this.getBurnout()));
        }
    }
}

