/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.capability.gear;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import net.jitl.common.items.base.JArmorItem;
import net.jitl.common.items.gear.FullArmorAbility;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.UnknownNullability;

public class PlayerArmor
implements INBTSerializable<CompoundTag> {
    private ArrayList<ItemStack> armorPieces;
    private FullArmorAbility fullSet;
    private CompoundTag nbt = new CompoundTag();

    public void copyFrom(PlayerArmor source) {
        this.armorPieces = source.armorPieces;
        this.fullSet = source.fullSet;
        this.nbt = source.nbt;
    }

    public void setArmor(Iterator<ItemStack> iterator) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ItemStack currentStack = iterator.next();
        Item item = currentStack.getItem();
        ArmorMaterial material = null;
        FullArmorAbility fullArmorAbility = null;
        if (item instanceof JArmorItem) {
            stacks.add(currentStack);
            fullArmorAbility = Objects.requireNonNull(((JArmorItem)item).getAbility()).getFullAbility(this.nbt);
            if (fullArmorAbility != null) {
                material = (ArmorMaterial)((JArmorItem)item).getMaterial().value();
            }
        }
        while (iterator.hasNext()) {
            currentStack = iterator.next();
            item = currentStack.getItem();
            if (item instanceof JArmorItem) {
                if (((JArmorItem)item).getMaterial().value() != material) {
                    fullArmorAbility = null;
                    material = null;
                }
                stacks.add(currentStack);
                continue;
            }
            fullArmorAbility = null;
            material = null;
        }
        stacks.trimToSize();
        this.armorPieces = stacks;
        this.fullSet = fullArmorAbility;
    }

    public ArrayList<ItemStack> getArmor() {
        return this.armorPieces;
    }

    public FullArmorAbility getFullArmor() {
        return this.fullSet;
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.put("armor ability", (Tag)this.nbt);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.nbt = nbt.getCompound("armor ability");
    }
}

