/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.dialogue;

import net.jitl.common.dialogue.Dialogue;
import net.jitl.common.dialogue.DialogueNode;
import net.minecraft.resources.ResourceLocation;

public class DialogueBuilder {
    public static DialogueNode branch(NodeBuilder rootBuilder) {
        return rootBuilder.node;
    }

    public static Dialogue dialogue(ResourceLocation id, NodeBuilder rootNodeBuilder) {
        return DialogueBuilder.dialogue(id, rootNodeBuilder.node);
    }

    public static Dialogue dialogue(ResourceLocation id, DialogueNode rootNode) {
        return new Dialogue(id, rootNode);
    }

    public static NodeBuilder node(String text) {
        return new NodeBuilder(text);
    }

    public static OptionBuilder option(String text) {
        return new OptionBuilder("> " + text);
    }

    public static class NodeBuilder {
        private final DialogueNode node;

        private NodeBuilder(String text) {
            this.node = new DialogueNode(text);
        }

        public NodeBuilder addOption(OptionBuilder builder) {
            this.node.addOption(builder.option);
            return this;
        }
    }

    public static class OptionBuilder {
        private final DialogueNode.Option option;

        private OptionBuilder(String text) {
            this.option = new DialogueNode.Option(text);
        }

        public OptionBuilder leadsTo(NodeBuilder nextNode) {
            this.option.setNextNode(nextNode.node);
            return this;
        }

        public OptionBuilder withAction(DialogueNode.Action action) {
            this.option.setOnClickAction(action);
            return this;
        }
    }
}

