/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.dialogue;

import java.util.HashMap;
import java.util.UUID;
import net.jitl.common.dialogue.Dialogue;
import net.jitl.common.dialogue.DialogueNetHandler;
import net.jitl.common.dialogue.DialogueNode;
import net.jitl.common.dialogue.DialogueRegistry;
import net.jitl.common.dialogue.DialogueSystemException;
import net.jitl.common.dialogue.DialogueTracker;
import net.jitl.common.dialogue.JRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class DialogueManager {
    private final DialogueNetHandler netHandler = new DialogueNetHandler();
    private final HashMap<UUID, DialogueTracker> trackers = new HashMap();

    public void startDialogue(ServerPlayer player, ResourceLocation npc, Dialogue dialogue) {
        DialogueRegistry dialogueRegistry = JRegistries.DIALOGUE_REGISTRY;
        dialogueRegistry.verifyRegistration(dialogue);
        this.startDialogue(player, npc, dialogue.getRootNode());
    }

    public DialogueNetHandler getNetHandler() {
        return this.netHandler;
    }

    private void startDialogue(ServerPlayer player, ResourceLocation npcClass, DialogueNode node) {
        DialogueTracker tracker = new DialogueTracker(player.getUUID(), npcClass, node);
        this.trackers.put(player.getUUID(), tracker);
        tracker.start(player);
    }

    public void handleDialogueChosenOption(ServerPlayer player, int optionIndex) throws DialogueSystemException {
        DialogueTracker dialogueTracker = this.trackers.get(player.getUUID());
        if (dialogueTracker == null) {
            throw new DialogueSystemException("There are no opened dialogues on server! What are you trying to do???");
        }
        dialogueTracker.pressOption(player, optionIndex);
    }

    void removeTracker(DialogueTracker tracker) {
        this.trackers.remove(tracker.getPlayerId());
    }
}

