/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.dialogue;

import java.util.ArrayList;
import net.jitl.client.gui.screen.dialogue.GuiDialogue;
import net.jitl.common.JManagers;
import net.jitl.common.dialogue.ClientDialogueNode;
import net.jitl.common.dialogue.DialogueSystemException;
import net.jitl.common.network.dialogue.C2SChosenOptionMsg;
import net.jitl.common.network.dialogue.S2CCloseDialogueGuiMsg;
import net.jitl.common.network.dialogue.S2COpenDialogueGuiMsg;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class DialogueNetHandler {
    @OnlyIn(value=Dist.CLIENT)
    public void handleDialogueClosePacket(S2CCloseDialogueGuiMsg message, IPayloadContext ctx) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen instanceof GuiDialogue) {
            mc.setScreen(null);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleDialogueOpenPacket(S2COpenDialogueGuiMsg message, IPayloadContext ctx) {
        int size = message.options().size();
        ArrayList<String> optionKeys = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            optionKeys.add(message.options().toString());
        }
        Minecraft.getInstance().setScreen((Screen)new GuiDialogue(new ClientDialogueNode(message.npcKey(), message.textKey(), optionKeys)));
    }

    public void handlePressOptionPacket(C2SChosenOptionMsg message, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            try {
                JManagers.DIALOGUE_MANAGER.handleDialogueChosenOption((ServerPlayer)ctx.player(), message.optionIndex());
            }
            catch (DialogueSystemException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

