/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.dialogue;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class DialogueNode {
    public static final DialogueNode END = new DialogueNode("");
    public static final Action EMPTY_ACTION = (world, player) -> {};
    private static final List<Option> STANDBY_END_OPTION_LIST = Collections.singletonList(new Option("dialogue.jitl.standby_end_option"));
    private final String text;
    private List<Option> options;
    public static final Codec<DialogueNode> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("text").forGetter(DialogueNode::getTextKey)).apply((Applicative)instance, DialogueNode::new));

    public DialogueNode(String text) {
        this.text = text;
    }

    public void addOption(Option option) {
        if (this.options == null) {
            this.options = new ArrayList<Option>();
        }
        this.options.add(option);
    }

    public List<Option> getOptions() {
        return this.options != null ? this.options : STANDBY_END_OPTION_LIST;
    }

    public String getTextKey() {
        return this.text;
    }

    public String toString() {
        return "DialogueNode{text='" + this.text + "', options=" + String.valueOf(this.options) + "}";
    }

    public static interface Action {
        public void onClick(Level var1, ServerPlayer var2);
    }

    public static class Option {
        private final String text;
        private DialogueNode nextNode = END;
        private Action onClickAction = EMPTY_ACTION;
        public static final Codec<Option> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("text").forGetter(Option::getText)).apply((Applicative)instance, Option::new));

        public Option(String text) {
            this.text = text;
        }

        public void setOnClickAction(Action onClickAction) {
            this.onClickAction = onClickAction;
        }

        public void setNextNode(DialogueNode nextNode) {
            this.nextNode = nextNode;
        }

        public String getText() {
            return this.text;
        }

        public DialogueNode getNextNode() {
            return this.nextNode;
        }

        public void onClickAction(Level world, ServerPlayer player) {
            this.onClickAction.onClick(world, player);
        }

        public String toString() {
            return "Option{text='" + this.text + "', hasNextNode=" + (this.nextNode != END) + "}";
        }
    }
}

