/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.dialogue;

import java.util.HashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import net.jitl.common.dialogue.Dialogue;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class DialogueRegistry {
    private final HashMap<ResourceLocation, Dialogue> dialogues = new HashMap();

    public Dialogue register(Dialogue dialogue) {
        if (this.dialogues.put(dialogue.getId(), dialogue) != null) {
            throw new IllegalArgumentException("Dialogue with id " + String.valueOf(dialogue.getId()) + " already registered!");
        }
        return dialogue;
    }

    @Nullable
    public Dialogue getDialogue(ResourceLocation id) {
        return this.dialogues.get(id);
    }

    public void verifyRegistration(Dialogue dialogue) throws IllegalArgumentException {
        if (this.dialogues.get(dialogue.getId()) == null) {
            throw new IllegalArgumentException("Dialogue " + String.valueOf(dialogue.getId()) + " isn't registered!");
        }
        if (!dialogue.equals(this.dialogues.get(dialogue.getId()))) {
            throw new IllegalArgumentException("Dialogue with id " + String.valueOf(dialogue.getId()) + " is registered but it doesn't equal provided one. Why did you make new dialogue instance with the same id???");
        }
    }
}

