/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.dialogue;

import java.util.UUID;
import net.jitl.common.JManagers;
import net.jitl.common.dialogue.DialogueNode;
import net.jitl.common.dialogue.DialogueSystemException;
import net.jitl.common.network.dialogue.S2CCloseDialogueGuiMsg;
import net.jitl.common.network.dialogue.S2COpenDialogueGuiMsg;
import net.jitl.core.data.JNetworkRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class DialogueTracker {
    private final UUID playerId;
    private final ResourceLocation npcClass;
    private DialogueNode currentNode;

    public DialogueTracker(UUID playerId, ResourceLocation npcClass, DialogueNode currentNode) {
        this.playerId = playerId;
        this.npcClass = npcClass;
        this.currentNode = currentNode;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public DialogueNode getCurrentNode() {
        return this.currentNode;
    }

    public void start(ServerPlayer player) {
        this.openGuiWithCurrentNode(player);
    }

    public void pressOption(ServerPlayer player, int optionIndex) throws DialogueSystemException {
        if (optionIndex >= this.currentNode.getOptions().size()) {
            throw new DialogueSystemException("Tracker received the index " + optionIndex + "that doesn't fit options list size (" + this.currentNode.getOptions().size() + "). Problem node: " + String.valueOf(this.currentNode));
        }
        DialogueNode.Option option = this.currentNode.getOptions().get(optionIndex);
        option.onClickAction(player.level(), player);
        this.currentNode = option.getNextNode();
        if (this.currentNode == DialogueNode.END) {
            JManagers.DIALOGUE_MANAGER.removeTracker(this);
            this.closeGui(player);
        } else {
            this.openGuiWithCurrentNode(player);
        }
    }

    private void openGuiWithCurrentNode(ServerPlayer player) {
        JNetworkRegistry.sendToPlayer(player, new S2COpenDialogueGuiMsg(this.npcClass, this.currentNode.getTextKey(), this.currentNode.getOptions()));
    }

    private void closeGui(ServerPlayer player) {
        JNetworkRegistry.sendToPlayer(player, new S2CCloseDialogueGuiMsg());
    }
}

