/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.base;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPaddleBoatPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBoat
extends Boat {
    private static final EntityDataAccessor<Integer> DATAIDHURT = SynchedEntityData.defineId(JBoat.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATAIDHURTDIR = SynchedEntityData.defineId(JBoat.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DATAIDDAMAGE = SynchedEntityData.defineId(JBoat.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DATAIDTYPE = SynchedEntityData.defineId(JBoat.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATAIDPADDLELEFT = SynchedEntityData.defineId(JBoat.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATAIDPADDLERIGHT = SynchedEntityData.defineId(JBoat.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATAIDBUBBLETIME = SynchedEntityData.defineId(JBoat.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final float[] paddlePositions = new float[2];
    private float outOfControlTicks;
    private float deltaRotation;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private boolean inputLeft;
    private boolean inputRight;
    private boolean inputUp;
    private boolean inputDown;
    private double waterLevel;
    private float landFriction;
    private Status status;
    private Status oldStatus;
    private double lastYd;
    private boolean isAboveBubbleColumn;
    private boolean bubbleColumnDirectionIsDown;
    private float bubbleMultiplier;
    private float bubbleAngle;
    private float bubbleAngleO;

    public JBoat(EntityType<? extends JBoat> entityType, Level level) {
        super(entityType, level);
        this.blocksBuilding = true;
    }

    public JBoat(Level world, double x, double y, double z) {
        super((EntityType)JEntities.JBOAT_TYPE.get(), world);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATAIDHURT, (Object)0);
        pBuilder.define(DATAIDHURTDIR, (Object)1);
        pBuilder.define(DATAIDDAMAGE, (Object)Float.valueOf(0.0f));
        pBuilder.define(DATAIDTYPE, (Object)Type.GOLD_EUCA.ordinal());
        pBuilder.define(DATAIDPADDLELEFT, (Object)false);
        pBuilder.define(DATAIDPADDLERIGHT, (Object)false);
        pBuilder.define(DATAIDBUBBLETIME, (Object)0);
    }

    public boolean canCollideWith(@NotNull Entity entity) {
        return JBoat.canVehicleCollide((Entity)this, entity);
    }

    public static boolean canVehicleCollide(@NotNull Entity entity, Entity other) {
        return (other.canBeCollidedWith() || other.isPushable()) && !entity.isPassengerOfSameVehicle(other);
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean isPushable() {
        return true;
    }

    @NotNull
    public Vec3 getRelativePortalPosition(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Direction.Axis axis, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BlockUtil.FoundRectangle portal) {
        return LivingEntity.resetForwardDirectionOfRelativePortalPosition((Vec3)super.getRelativePortalPosition(axis, portal));
    }

    protected Vec3 getPassengerAttachmentPoint(Entity pEntity, EntityDimensions pDimensions, float pPartialTick) {
        float f = this.getSinglePassengerXOffset();
        if (this.getPassengers().size() > 1) {
            int i = this.getPassengers().indexOf(pEntity);
            f = i == 0 ? 0.2f : -0.6f;
            if (pEntity instanceof Animal) {
                f += 0.2f;
            }
        }
        return new Vec3(0.0, (double)(pDimensions.height() / 3.0f), (double)f).yRot(-this.getYRot() * ((float)Math.PI / 180));
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (!this.level().isClientSide && !this.isRemoved()) {
            boolean flag;
            this.setHurtDir(-this.getHurtDir());
            this.setHurtTime(10);
            this.setDamage(this.getDamage() + amount * 10.0f);
            this.markHurt();
            this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, source.getEntity());
            boolean bl = flag = source.getEntity() instanceof Player && ((Player)source.getEntity()).getAbilities().instabuild;
            if (flag || this.getDamage() > 40.0f) {
                if (!flag && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                    this.spawnAtLocation((ItemLike)this.getDropItem());
                }
                this.discard();
            }
            return true;
        }
        return true;
    }

    public void onAboveBubbleCol(boolean downwards) {
        if (!this.level().isClientSide) {
            this.isAboveBubbleColumn = true;
            this.bubbleColumnDirectionIsDown = downwards;
            if (this.getBubbleTime() == 0) {
                this.setBubbleTime(60);
            }
        }
        this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() + (double)this.random.nextFloat(), this.getY() + 0.7, this.getZ() + (double)this.random.nextFloat(), 0.0, 0.0, 0.0);
        if (this.random.nextInt(20) == 0) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), this.getSwimSplashSound(), this.getSoundSource(), 1.0f, 0.8f + 0.4f * this.random.nextFloat(), false);
        }
        this.gameEvent((Holder)GameEvent.SPLASH, (Entity)this.getControllingPassenger());
    }

    public void push(@NotNull Entity entity) {
        if (entity instanceof JBoat) {
            if (entity.getBoundingBox().minY < this.getBoundingBox().maxY) {
                super.push(entity);
            }
        } else if (entity.getBoundingBox().minY <= this.getBoundingBox().minY) {
            super.push(entity);
        }
    }

    @NotNull
    public Item getDropItem() {
        return switch (this.getJBoatType().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> (Item)JItems.GOLDEN_EUCA_BOAT.get();
            case 1 -> (Item)JItems.BROWN_EUCA_BOAT.get();
            case 2 -> (Item)JItems.FROZEN_BOAT.get();
            case 3 -> (Item)JItems.DEPTHS_BOAT.get();
            case 4 -> (Item)JItems.BURNED_BOAT.get();
            case 5 -> (Item)JItems.CORBA_BOAT.get();
            case 6 -> (Item)JItems.TERRANIAN_BOAT.get();
            case 7 -> (Item)JItems.CLOUDIA_BOAT.get();
        };
    }

    public void animateHurt(float f) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    public void lerpTo(double x, double y, double z, float yRot, float xRot, int steps) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yRot;
        this.lerpXRot = xRot;
        this.lerpSteps = 10;
    }

    public double lerpTargetX() {
        return this.lerpSteps > 0 ? this.lerpX : this.getX();
    }

    public double lerpTargetY() {
        return this.lerpSteps > 0 ? this.lerpY : this.getY();
    }

    public double lerpTargetZ() {
        return this.lerpSteps > 0 ? this.lerpZ : this.getZ();
    }

    public float lerpTargetXRot() {
        return this.lerpSteps > 0 ? (float)this.lerpXRot : this.getXRot();
    }

    public float lerpTargetYRot() {
        return this.lerpSteps > 0 ? (float)this.lerpYRot : this.getYRot();
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    @NotNull
    public Direction getMotionDirection() {
        return this.getDirection().getClockWise();
    }

    public void tick() {
        this.oldStatus = this.status;
        this.status = this.getStatus();
        this.outOfControlTicks = this.status != Status.UNDERWATER && this.status != Status.UNDER_FLOWING_WATER ? 0.0f : (this.outOfControlTicks += 1.0f);
        if (!this.level().isClientSide && this.outOfControlTicks >= 60.0f) {
            this.ejectPassengers();
        }
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        this.tickLerp();
        if (this.isControlledByLocalInstance()) {
            if (!(this.getFirstPassenger() instanceof Player)) {
                this.setPaddleState(false, false);
            }
            this.floatJBoat();
            if (this.level().isClientSide) {
                this.controlJBoat();
                this.level().sendPacketToServer((Packet)new ServerboundPaddleBoatPacket(this.getPaddleState(0), this.getPaddleState(1)));
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
        } else {
            this.setDeltaMovement(Vec3.ZERO);
        }
        this.tickBubbleColumn();
        for (int i = 0; i <= 1; ++i) {
            if (this.getPaddleState(i)) {
                SoundEvent soundevent;
                if (!this.isSilent() && (double)(this.paddlePositions[i] % ((float)Math.PI * 2)) <= 0.7853981852531433 && ((double)this.paddlePositions[i] + (double)0.3926991f) % 6.2831854820251465 >= 0.7853981852531433 && (soundevent = this.getPaddleSound()) != null) {
                    Vec3 vec3 = this.getViewVector(1.0f);
                    double d0 = i == 1 ? -vec3.z : vec3.z;
                    double d1 = i == 1 ? vec3.x : -vec3.x;
                    this.level().playSound(null, this.getX() + d0, this.getY(), this.getZ() + d1, soundevent, this.getSoundSource(), 1.0f, 0.8f + 0.4f * this.random.nextFloat());
                }
                this.paddlePositions[i] = (float)((double)this.paddlePositions[i] + (double)0.3926991f);
                continue;
            }
            this.paddlePositions[i] = 0.0f;
        }
        this.checkInsideBlocks();
        List list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.pushableBy((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.level().isClientSide && !(this.getControllingPassenger() instanceof Player);
            for (Entity entity : list) {
                if (entity.hasPassenger((Entity)this)) continue;
                if (flag && this.getPassengers().size() < 2 && !entity.isPassenger() && entity.getBbWidth() < this.getBbWidth() && entity instanceof LivingEntity && !(entity instanceof WaterAnimal) && !(entity instanceof Player)) {
                    entity.startRiding((Entity)this);
                    continue;
                }
                this.push(entity);
            }
        }
    }

    private void tickBubbleColumn() {
        if (this.level().isClientSide) {
            int i = this.getBubbleTime();
            this.bubbleMultiplier = i > 0 ? (this.bubbleMultiplier += 0.05f) : (this.bubbleMultiplier -= 0.1f);
            this.bubbleMultiplier = Mth.clamp((float)this.bubbleMultiplier, (float)0.0f, (float)1.0f);
            this.bubbleAngleO = this.bubbleAngle;
            this.bubbleAngle = 10.0f * (float)Math.sin(0.5f * (float)this.level().getGameTime()) * this.bubbleMultiplier;
        } else {
            int k;
            if (!this.isAboveBubbleColumn) {
                this.setBubbleTime(0);
            }
            if ((k = this.getBubbleTime()) > 0) {
                this.setBubbleTime(--k);
                int j = 60 - k - 1;
                if (j > 0 && k == 0) {
                    this.setBubbleTime(0);
                    Vec3 vec3 = this.getDeltaMovement();
                    if (this.bubbleColumnDirectionIsDown) {
                        this.setDeltaMovement(vec3.add(0.0, -0.7, 0.0));
                        this.ejectPassengers();
                    } else {
                        this.setDeltaMovement(vec3.x, this.hasPassenger(entity1 -> entity1 instanceof Player) ? 2.7 : 0.6, vec3.z);
                    }
                }
                this.isAboveBubbleColumn = false;
            }
        }
    }

    @Nullable
    protected SoundEvent getPaddleSound() {
        return switch (this.getStatus().ordinal()) {
            case 0, 1, 2 -> SoundEvents.BOAT_PADDLE_WATER;
            case 3 -> SoundEvents.BOAT_PADDLE_LAND;
            default -> null;
        };
    }

    private void tickLerp() {
        if (this.isControlledByLocalInstance()) {
            this.lerpSteps = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
        }
        if (this.lerpSteps > 0) {
            this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
            --this.lerpSteps;
        }
    }

    public void setPaddleState(boolean left, boolean right) {
        this.entityData.set(DATAIDPADDLELEFT, (Object)left);
        this.entityData.set(DATAIDPADDLERIGHT, (Object)right);
    }

    public float getRowingTime(int side, float limbSwing) {
        return this.getPaddleState(side) ? Mth.clampedLerp((float)(this.paddlePositions[side] - 0.3926991f), (float)this.paddlePositions[side], (float)limbSwing) : 0.0f;
    }

    private Status getStatus() {
        Status s = this.isUnderwater();
        if (s != null) {
            this.waterLevel = this.getBoundingBox().maxY;
            return s;
        }
        if (this.checkInWater()) {
            return Status.IN_WATER;
        }
        float f = this.getGroundFriction();
        if (f > 0.0f) {
            this.landFriction = f;
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    public float getWaterLevelAbove() {
        AABB aabb = this.getBoundingBox();
        int i = Mth.floor((double)aabb.minX);
        int j = Mth.ceil((double)aabb.maxX);
        int k = Mth.floor((double)aabb.maxY);
        int l = Mth.ceil((double)(aabb.maxY - this.lastYd));
        int i1 = Mth.floor((double)aabb.minZ);
        int j1 = Mth.ceil((double)aabb.maxZ);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    pos.set(l1, k1, i2);
                    FluidState fluidstate = this.level().getFluidState((BlockPos)pos);
                    if (fluidstate.is(FluidTags.WATER)) {
                        f = Math.max(f, fluidstate.getHeight((BlockGetter)this.level(), (BlockPos)pos));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)pos.getY() + f;
        }
        return l + 1;
    }

    public float getGroundFriction() {
        AABB aabb = this.getBoundingBox();
        AABB aabb1 = new AABB(aabb.minX, aabb.minY - 0.001, aabb.minZ, aabb.maxX, aabb.minY, aabb.maxZ);
        int i = Mth.floor((double)aabb1.minX) - 1;
        int j = Mth.ceil((double)aabb1.maxX) + 1;
        int k = Mth.floor((double)aabb1.minY) - 1;
        int l = Mth.ceil((double)aabb1.maxY) + 1;
        int i1 = Mth.floor((double)aabb1.minZ) - 1;
        int j1 = Mth.ceil((double)aabb1.maxZ) + 1;
        VoxelShape voxelshape = Shapes.create((AABB)aabb1);
        float f = 0.0f;
        int k1 = 0;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    pos.set(l1, k2, i2);
                    BlockState blockstate = this.level().getBlockState((BlockPos)pos);
                    if (blockstate.getBlock() instanceof WaterlilyBlock || !Shapes.joinIsNotEmpty((VoxelShape)blockstate.getCollisionShape((BlockGetter)this.level(), (BlockPos)pos).move((double)l1, (double)k2, (double)i2), (VoxelShape)voxelshape, (BooleanOp)BooleanOp.AND)) continue;
                    f += blockstate.getFriction((LevelReader)this.level(), (BlockPos)pos, (Entity)this);
                    ++k1;
                }
            }
        }
        return f / (float)k1;
    }

    private boolean checkInWater() {
        AABB aabb = this.getBoundingBox();
        int i = Mth.floor((double)aabb.minX);
        int j = Mth.ceil((double)aabb.maxX);
        int k = Mth.floor((double)aabb.minY);
        int l = Mth.ceil((double)(aabb.minY + 0.001));
        int i1 = Mth.floor((double)aabb.minZ);
        int j1 = Mth.ceil((double)aabb.maxZ);
        boolean flag = false;
        this.waterLevel = -1.7976931348623157E308;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    pos.set(k1, l1, i2);
                    FluidState fluidstate = this.level().getFluidState((BlockPos)pos);
                    if (!fluidstate.is(FluidTags.WATER)) continue;
                    float f = (float)l1 + fluidstate.getHeight((BlockGetter)this.level(), (BlockPos)pos);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag |= aabb.minY < (double)f;
                }
            }
        }
        return flag;
    }

    @Nullable
    private Status isUnderwater() {
        AABB aabb = this.getBoundingBox();
        double d0 = aabb.maxY + 0.001;
        int i = Mth.floor((double)aabb.minX);
        int j = Mth.ceil((double)aabb.maxX);
        int k = Mth.floor((double)aabb.maxY);
        int l = Mth.ceil((double)d0);
        int i1 = Mth.floor((double)aabb.minZ);
        int j1 = Mth.ceil((double)aabb.maxZ);
        boolean flag = false;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    pos.set(k1, l1, i2);
                    FluidState fluidstate = this.level().getFluidState((BlockPos)pos);
                    if (!fluidstate.is(FluidTags.WATER) || !(d0 < (double)((float)pos.getY() + fluidstate.getHeight((BlockGetter)this.level(), (BlockPos)pos)))) continue;
                    if (!fluidstate.isSource()) {
                        return Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? Status.UNDERWATER : null;
    }

    private void floatJBoat() {
        double d1 = this.isNoGravity() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        float invFriction = 0.05f;
        if (this.oldStatus == Status.IN_AIR && this.status != Status.IN_AIR && this.status != Status.ON_LAND) {
            this.waterLevel = this.getY(1.0);
            this.setPos(this.getX(), (double)(this.getWaterLevelAbove() - this.getBbHeight()) + 0.101, this.getZ());
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.0, 1.0));
            this.lastYd = 0.0;
            this.status = Status.IN_WATER;
        } else {
            if (this.status == Status.IN_WATER) {
                d2 = (this.waterLevel - this.getY()) / (double)this.getBbHeight();
                invFriction = 0.9f;
            } else if (this.status == Status.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                invFriction = 0.9f;
            } else if (this.status == Status.UNDERWATER) {
                d2 = 0.01f;
                invFriction = 0.45f;
            } else if (this.status == Status.IN_AIR) {
                invFriction = 0.9f;
            } else if (this.status == Status.ON_LAND) {
                invFriction = this.landFriction;
                if (this.getControllingPassenger() instanceof Player) {
                    this.landFriction /= 2.0f;
                }
            }
            Vec3 vec3 = this.getDeltaMovement();
            this.setDeltaMovement(vec3.x * (double)invFriction, vec3.y + d1, vec3.z * (double)invFriction);
            this.deltaRotation *= invFriction;
            if (d2 > 0.0) {
                Vec3 vec31 = this.getDeltaMovement();
                this.setDeltaMovement(vec31.x, (vec31.y + d2 * 0.06153846016296973) * 0.75, vec31.z);
            }
        }
    }

    private void controlJBoat() {
        if (this.isVehicle()) {
            float f = 0.0f;
            if (this.inputLeft) {
                this.deltaRotation -= 1.0f;
            }
            if (this.inputRight) {
                this.deltaRotation += 1.0f;
            }
            if (this.inputRight != this.inputLeft && !this.inputUp && !this.inputDown) {
                f += 0.005f;
            }
            this.setYRot(this.getYRot() + this.deltaRotation);
            if (this.inputUp) {
                f += 0.04f;
            }
            if (this.inputDown) {
                f -= 0.005f;
            }
            this.setDeltaMovement(this.getDeltaMovement().add((double)(Mth.sin((float)(-this.getYRot() * ((float)Math.PI / 180))) * f), 0.0, (double)(Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * f)));
            this.setPaddleState(this.inputRight && !this.inputLeft || this.inputUp, this.inputLeft && !this.inputRight || this.inputUp);
        }
    }

    protected void positionRider(Entity pPassenger, Entity.MoveFunction pCallback) {
        super.positionRider(pPassenger, pCallback);
        pPassenger.setYRot(pPassenger.getYRot() + this.deltaRotation);
        pPassenger.setYHeadRot(pPassenger.getYHeadRot() + this.deltaRotation);
        this.clampRotation(pPassenger);
        if (pPassenger instanceof Animal && this.getPassengers().size() == this.getMaxPassengers()) {
            int i = pPassenger.getId() % 2 == 0 ? 90 : 270;
            pPassenger.setYBodyRot(((Animal)pPassenger).yBodyRot + (float)i);
            pPassenger.setYHeadRot(pPassenger.getYHeadRot() + (float)i);
        }
    }

    @NotNull
    public Vec3 getDismountLocationForPassenger(LivingEntity livingEntity) {
        Vec3 vec3 = JBoat.getCollisionHorizontalEscapeVector((double)(this.getBbWidth() * Mth.SQRT_OF_TWO), (double)livingEntity.getBbWidth(), (float)livingEntity.getYRot());
        double d0 = this.getX() + vec3.x;
        double d1 = this.getZ() + vec3.z;
        BlockPos blockpos = BlockPos.containing((double)d0, (double)this.getBoundingBox().maxY, (double)d1);
        BlockPos blockpos1 = blockpos.below();
        if (!this.level().isWaterAt(blockpos1)) {
            double d3;
            ArrayList list = Lists.newArrayList();
            double d2 = this.level().getBlockFloorHeight(blockpos);
            if (DismountHelper.isBlockFloorValid((double)d2)) {
                list.add(new Vec3(d0, (double)blockpos.getY() + d2, d1));
            }
            if (DismountHelper.isBlockFloorValid((double)(d3 = this.level().getBlockFloorHeight(blockpos1)))) {
                list.add(new Vec3(d0, (double)blockpos1.getY() + d3, d1));
            }
            for (Pose pose : livingEntity.getDismountPoses()) {
                for (Vec3 vec31 : list) {
                    if (!DismountHelper.canDismountTo((CollisionGetter)this.level(), (Vec3)vec31, (LivingEntity)livingEntity, (Pose)pose)) continue;
                    livingEntity.setPose(pose);
                    return vec31;
                }
            }
        }
        return super.getDismountLocationForPassenger(livingEntity);
    }

    protected void clampRotation(Entity entityToUpdate) {
        entityToUpdate.setYBodyRot(this.getYRot());
        float f = Mth.wrapDegrees((float)(entityToUpdate.getYRot() - this.getYRot()));
        float f1 = Mth.clamp((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.yRotO += f1 - f;
        entityToUpdate.setYRot(entityToUpdate.getYRot() + f1 - f);
        entityToUpdate.setYHeadRot(entityToUpdate.getYRot());
    }

    public void onPassengerTurned(@NotNull Entity entityToUpdate) {
        this.clampRotation(entityToUpdate);
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putString("Type", this.getJBoatType().getName());
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("Type", 8)) {
            this.setType(Type.byName(compound.getString("Type")));
        }
    }

    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        if (player.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        if (this.outOfControlTicks < 60.0f) {
            if (!this.level().isClientSide) {
                return player.startRiding((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void checkFallDamage(double y, boolean onGround, @Nullable BlockState state, @Nullable BlockPos pos) {
        this.lastYd = this.getDeltaMovement().y;
        if (!this.isPassenger()) {
            if (onGround) {
                if (this.fallDistance > 3.0f) {
                    if (this.status != Status.ON_LAND) {
                        this.resetFallDistance();
                        return;
                    }
                    this.causeFallDamage(this.fallDistance, 1.0f, this.damageSources().fall());
                    if (!this.level().isClientSide && !this.isRemoved()) {
                        this.kill();
                        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                            for (int i = 0; i < 3; ++i) {
                                this.spawnAtLocation((ItemLike)this.getJBoatType().getPlanks());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.spawnAtLocation((ItemLike)Items.STICK);
                            }
                        }
                    }
                }
                this.resetFallDistance();
            } else if (!this.level().getFluidState(this.blockPosition().below()).is(FluidTags.WATER) && y < 0.0) {
                this.fallDistance = (float)((double)this.fallDistance - y);
            }
        }
    }

    public boolean getPaddleState(int side) {
        return (Boolean)this.entityData.get(side == 0 ? DATAIDPADDLELEFT : DATAIDPADDLERIGHT) != false && this.getControllingPassenger() != null;
    }

    public void setDamage(float damageTaken) {
        this.entityData.set(DATAIDDAMAGE, (Object)Float.valueOf(damageTaken));
    }

    public float getDamage() {
        return ((Float)this.entityData.get(DATAIDDAMAGE)).floatValue();
    }

    public void setHurtTime(int timeSinceHit) {
        this.entityData.set(DATAIDHURT, (Object)timeSinceHit);
    }

    public int getHurtTime() {
        return (Integer)this.entityData.get(DATAIDHURT);
    }

    private void setBubbleTime(int ticks) {
        this.entityData.set(DATAIDBUBBLETIME, (Object)ticks);
    }

    private int getBubbleTime() {
        return (Integer)this.entityData.get(DATAIDBUBBLETIME);
    }

    public float getBubbleAngle(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.bubbleAngleO, (float)this.bubbleAngle);
    }

    public void setHurtDir(int forwardDirection) {
        this.entityData.set(DATAIDHURTDIR, (Object)forwardDirection);
    }

    public int getHurtDir() {
        return (Integer)this.entityData.get(DATAIDHURTDIR);
    }

    public void setType(Type JBoatType) {
        this.entityData.set(DATAIDTYPE, (Object)JBoatType.ordinal());
    }

    public Type getJBoatType() {
        return Type.byId((Integer)this.entityData.get(DATAIDTYPE));
    }

    protected boolean canAddPassenger(@NotNull Entity passenger) {
        return this.getPassengers().size() < this.getMaxPassengers() && !this.canBoatInFluid(this.getEyeInFluidType());
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        LivingEntity livingentity;
        Entity entity = this.getFirstPassenger();
        LivingEntity livingentity1 = entity instanceof LivingEntity ? (livingentity = (LivingEntity)entity) : null;
        return livingentity1;
    }

    public void setInput(boolean leftInputDown, boolean rightInputDown, boolean forwardInputDown, boolean backInputDown) {
        this.inputLeft = leftInputDown;
        this.inputRight = rightInputDown;
        this.inputUp = forwardInputDown;
        this.inputDown = backInputDown;
    }

    public boolean isUnderWater() {
        return this.status == Status.UNDERWATER || this.status == Status.UNDER_FLOWING_WATER;
    }

    protected void addPassenger(@NotNull Entity passenger) {
        super.addPassenger(passenger);
        if (this.isControlledByLocalInstance() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.absMoveTo(this.lerpX, this.lerpY, this.lerpZ, (float)this.lerpYRot, (float)this.lerpXRot);
        }
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)this.getDropItem());
    }

    public static enum Type {
        GOLD_EUCA((Block)JBlocks.EUCA_GOLD_PLANKS.get(), "gold_euca"),
        BROWN_EUCA((Block)JBlocks.EUCA_BROWN_PLANKS.get(), "brown_euca"),
        FROZEN((Block)JBlocks.FROZEN_PLANKS.get(), "frozen"),
        DEPTHS((Block)JBlocks.DEPTHS_PLANKS.get(), "depths"),
        BURNED((Block)JBlocks.BURNED_PLANKS.get(), "burned"),
        CORBA((Block)JBlocks.CORBA_PLANKS.get(), "corba"),
        TERRANIA((Block)JBlocks.TERRANIAN_PLANKS.get(), "terranian"),
        CLOUDIA((Block)JBlocks.CLOUDIA_PLANKS.get(), "cloudia");

        private final String name;
        private final Block planks;

        private Type(Block baseBlock, String name) {
            this.name = name;
            this.planks = baseBlock;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int id) {
            Type[] b = Type.values();
            if (id < 0 || id >= b.length) {
                id = 0;
            }
            return b[id];
        }

        public static Type byName(String name) {
            Type[] b;
            for (Type type : b = Type.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return b[0];
        }
    }

    public static enum Status {
        IN_WATER,
        UNDERWATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

