/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.base;

import java.util.Objects;
import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.capability.stats.PlayerStats;
import net.jitl.common.entity.base.IDontAttackWhenPeaceful;
import net.jitl.common.entity.base.JMonsterEntity;
import net.jitl.common.entity.boss.BossCrystal;
import net.jitl.core.init.internal.JDataAttachments;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JBossEntity
extends JMonsterEntity
implements IDontAttackWhenPeaceful {
    private final ServerBossEvent BOSS_INFO = (ServerBossEvent)new ServerBossEvent(Objects.requireNonNull(this.getDisplayName()), BossEvent.BossBarColor.PINK, BossEvent.BossBarOverlay.NOTCHED_20).setDarkenScreen(false).setCreateWorldFog(false);
    protected EnumKnowledge knowledge;
    protected int knowledgeLevel = 0;

    protected JBossEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.BOSS_INFO.id = this.getUUID();
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    public boolean wantsToAttack(LivingEntity target, LivingEntity living) {
        return this.level().getDifficulty() != Difficulty.PEACEFUL;
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)JSounds.BOSS_DEATH.get();
    }

    public float getSoundVolume() {
        return 10.0f;
    }

    protected abstract BossCrystal.Type getDeathCrystalType();

    public abstract ResourceKey<LootTable> lootTable();

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (this.hasCustomName()) {
            this.BOSS_INFO.setName(Objects.requireNonNull(this.getDisplayName()));
        }
        this.BOSS_INFO.id = this.getUUID();
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        this.BOSS_INFO.setName(Objects.requireNonNull(this.getDisplayName()));
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        this.BOSS_INFO.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public void startSeenByPlayer(@NotNull ServerPlayer player) {
        super.startSeenByPlayer(player);
        if (this.showBarWhenSpawned()) {
            this.BOSS_INFO.addPlayer(player);
        }
    }

    public void stopSeenByPlayer(@NotNull ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.BOSS_INFO.removePlayer(player);
    }

    public abstract boolean showBarWhenSpawned();

    public boolean hurt(@NotNull DamageSource d, float f) {
        if (!this.level().isClientSide() && !this.showBarWhenSpawned() && d.getEntity() instanceof Player) {
            AABB axisalignedbb = AABB.unitCubeFromLowerCorner((Vec3)this.position()).inflate(10.0);
            for (Player player : this.level().getEntitiesOfClass(Player.class, axisalignedbb)) {
                this.BOSS_INFO.addPlayer((ServerPlayer)player);
            }
        }
        return super.hurt(d, f);
    }

    public void setKnowledge(EnumKnowledge knowledge, int level) {
        this.knowledge = knowledge;
        this.knowledgeLevel = level;
    }

    @Override
    public void die(@NotNull DamageSource s) {
        super.die(s);
        Entity entity = s.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.knowledge != null) {
                ((PlayerStats)player.getData(JDataAttachments.PLAYER_STATS)).addLevel(this.knowledge, this.knowledgeLevel);
            }
        }
        if (!this.level().isClientSide()) {
            BossCrystal crystal = new BossCrystal((EntityType<? extends BossCrystal>)((EntityType)JEntities.BOSS_CRYSTAL_TYPE.get()), this.level(), this.getDeathCrystalType(), this.lootTable());
            crystal.setPos(this.position().add(0.0, 1.0, 0.0));
            this.level().addFreshEntity((Entity)crystal);
        }
    }
}

