/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.base;

import java.util.EnumSet;
import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.capability.stats.PlayerStats;
import net.jitl.core.init.internal.JDataAttachments;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class JFlyingEntity
extends FlyingMob
implements Enemy,
GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private double speed = 0.3;
    protected EnumKnowledge knowledge;
    protected float knowledgeAmount = 0.0f;

    public JFlyingEntity(EntityType<? extends JFlyingEntity> type, Level world) {
        super(type, world);
        this.moveControl = new MoveHelperController(this);
    }

    public boolean checkSpawnRules(LevelAccessor level, MobSpawnType type) {
        return !level.getBiome(this.blockPosition()).is(Tags.Biomes.IS_MUSHROOM) && !level.getBiome(this.blockPosition()).is(Biomes.DEEP_DARK);
    }

    public void setKnowledge(EnumKnowledge knowledge, float amount) {
        this.knowledge = knowledge;
        this.knowledgeAmount = amount;
    }

    protected abstract void controller(AnimatableManager.ControllerRegistrar var1);

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        this.controller(controllers);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setFlyingSpeed(double speed) {
        this.speed = speed;
    }

    public void die(@NotNull DamageSource cause) {
        super.die(cause);
        Entity entity = cause.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.knowledge != null) {
                ((PlayerStats)player.getData(JDataAttachments.PLAYER_STATS)).addXP(this.knowledge, this.knowledgeAmount, player);
            }
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(5, (Goal)new RandomFlyGoal(this, this.speed));
        this.goalSelector.addGoal(7, (Goal)new LookAroundGoal(this));
        this.addGoals();
    }

    public abstract void addGoals();

    protected boolean shouldDespawnInPeaceful() {
        return this.despawnInPeaceful();
    }

    public abstract boolean despawnInPeaceful();

    static class MoveHelperController
    extends MoveControl {
        private final JFlyingEntity entity;
        private int floatDuration;

        public MoveHelperController(JFlyingEntity entity) {
            super((Mob)entity);
            this.entity = entity;
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
                this.floatDuration += this.entity.getRandom().nextInt(3) + 1;
                Vec3 vector3d = new Vec3(this.wantedX - this.entity.getX(), this.wantedY - this.entity.getY(), this.wantedZ - this.entity.getZ());
                double d0 = vector3d.length();
                if (this.canReach(vector3d = vector3d.normalize(), Mth.ceil((double)d0))) {
                    this.entity.setDeltaMovement(this.entity.getDeltaMovement().add(vector3d.scale(0.1)));
                } else {
                    this.operation = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean canReach(Vec3 vector3d_, int int_) {
            AABB a = this.entity.getBoundingBox();
            for (int i = 1; i < int_; ++i) {
                a = a.move(vector3d_);
                if (this.entity.level().noCollision((Entity)this.entity, a)) continue;
                return false;
            }
            return true;
        }
    }

    static class RandomFlyGoal
    extends Goal {
        private final JFlyingEntity entity;
        public final double speed;

        public RandomFlyGoal(JFlyingEntity entity, double speed) {
            this.entity = entity;
            this.speed = speed;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            double d2;
            double d1;
            MoveControl m = this.entity.getMoveControl();
            if (!m.hasWanted()) {
                return true;
            }
            double d0 = m.getWantedX() - this.entity.getX();
            double d3 = d0 * d0 + (d1 = m.getWantedY() - this.entity.getY()) * d1 + (d2 = m.getWantedZ() - this.entity.getZ()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void start() {
            RandomSource random = this.entity.getRandom();
            double d0 = this.entity.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.entity.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.entity.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.entity.getMoveControl().setWantedPosition(d0, d1, d2, this.speed);
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final JFlyingEntity entity;

        public LookAroundGoal(JFlyingEntity entity) {
            this.entity = entity;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return true;
        }

        public void tick() {
            Vec3 vector3d = this.entity.getDeltaMovement();
            this.entity.setYRot(-((float)Mth.atan2((double)vector3d.x, (double)vector3d.z)) * 57.295776f);
            this.entity.yBodyRot = this.entity.getYRot();
        }
    }
}

