/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.base;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nullable;
import net.jitl.common.entity.base.JVillagerMob;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class JVillagerEntity
extends JVillagerMob
implements Npc,
Merchant,
Enemy,
GeoEntity {
    private Player playerEntity;
    protected MerchantOffers offers;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public JVillagerEntity(EntityType<? extends JVillagerMob> type, Level worldIn) {
        super(type, worldIn);
    }

    public void setTradingPlayer(@Nullable Player player) {
        this.playerEntity = player;
    }

    @Nullable
    public Player getTradingPlayer() {
        return this.playerEntity;
    }

    @NotNull
    public MerchantOffers getOffers() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.provideTrades();
        }
        return this.offers;
    }

    @Override
    protected abstract void controller(AnimatableManager.ControllerRegistrar var1);

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        this.controller(controllers);
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Nullable
    protected abstract Int2ObjectMap<VillagerTrades.ItemListing[]> getVillagerTrades();

    protected void provideTrades() {
        VillagerTrades.ItemListing[] trades = (VillagerTrades.ItemListing[])Objects.requireNonNull(this.getVillagerTrades()).get(1);
        if (trades != null) {
            MerchantOffers merchantOffers = this.getOffers();
            this.addTrades(merchantOffers, trades);
        }
    }

    protected void addTrades(MerchantOffers offers, VillagerTrades.ItemListing[] trades) {
        HashSet set = Sets.newHashSet();
        for (int i = 0; i < trades.length; ++i) {
            set.add(i);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            int int1 = (Integer)iterator.next();
            VillagerTrades.ItemListing villagerTrades = trades[int1];
            MerchantOffer merchantoffer = villagerTrades.getOffer((Entity)this, this.random);
            if (merchantoffer == null) continue;
            offers.add((Object)merchantoffer);
        }
    }

    public void overrideOffers(@Nullable MerchantOffers offers) {
    }

    public void notifyTrade(MerchantOffer offer) {
        offer.increaseUses();
        if (offer.shouldRewardExp()) {
            int i = 3 + this.random.nextInt(4);
            double y = this.getY() + (double)(this.getBbHeight() / 2.0f);
            this.level().addFreshEntity((Entity)new ExperienceOrb(this.level(), this.getX(), y, this.getZ(), i));
        }
    }

    public void trade(Player playerEntity) {
        if (!this.getOffers().isEmpty() && !this.level().isClientSide()) {
            this.setTradingPlayer(playerEntity);
            this.openTradingScreen(playerEntity, this.getDisplayName(), 1);
        }
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player playerEntity, @NotNull InteractionHand playerHand) {
        if (!this.isAlive() || this.playerEntity != null || !this.canTrade()) {
            return super.mobInteract(playerEntity, playerHand);
        }
        this.trade(playerEntity);
        return super.mobInteract(playerEntity, playerHand);
    }

    public boolean canTrade() {
        return true;
    }

    public void notifyTradeUpdated(@NotNull ItemStack stack) {
    }

    @NotNull
    public Level getLevel() {
        return this.level();
    }

    public int getVillagerXp() {
        return 0;
    }

    public void overrideXp(int xpIn) {
    }

    public boolean showProgressBar() {
        return false;
    }

    public SoundEvent getNotifyTradeSound() {
        return null;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public boolean isClientSide() {
        return this.getLevel().isClientSide;
    }
}

