/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.boss;

import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.entity.base.JBossEntity;
import net.jitl.common.entity.base.JMonsterEntity;
import net.jitl.common.entity.boss.BossCrystal;
import net.jitl.common.entity.goal.AttackWhenDifficultGoal;
import net.jitl.common.entity.goal.IdleHealGoal;
import net.jitl.core.init.internal.JLootTables;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;

public class Eudor
extends JBossEntity {
    private int FIRE_TICK = 0;
    private static final EntityDataAccessor<Boolean> IS_INVISIBLE = SynchedEntityData.defineId(Eudor.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.eudor.idle");
    private final RawAnimation MOVING = RawAnimation.begin().thenLoop("animation.eudor.walk");

    public Eudor(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setKnowledge(EnumKnowledge.EUCA, 10);
    }

    public boolean fireImmune() {
        return true;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(IS_INVISIBLE, (Object)false);
    }

    public boolean isInvisible() {
        return (Boolean)this.entityData.get(IS_INVISIBLE);
    }

    public void setInvisible(boolean isInvis) {
        this.entityData.set(IS_INVISIBLE, (Object)isInvis);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)JSounds.CALCIA_IDLE.get();
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)JSounds.CALCIA_HURT.get();
    }

    public void tick() {
        super.tick();
        int FIRE_MAX = 400;
        if (FIRE_MAX == this.FIRE_TICK && this.FIRE_TICK != 0) {
            this.setInvisible(true);
            this.FIRE_TICK = 0;
        } else {
            ++this.FIRE_TICK;
        }
        int FIRE_MAX_2 = 300;
        if (FIRE_MAX_2 == this.FIRE_TICK && this.FIRE_TICK != 0) {
            this.setInvisible(false);
            this.FIRE_TICK = 0;
        } else {
            ++this.FIRE_TICK;
        }
        if (this.isInvisible()) {
            if (this.level().isClientSide) {
                for (int i = 0; i < 5; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.ENCHANT, this.position().x + (this.random.nextDouble() - 0.5), this.position().y + this.random.nextDouble(), this.position().z + (this.random.nextDouble() - 0.5), (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
                }
            }
            this.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 25));
            LivingEntity entity = this.getLastAttacker();
            if (entity != null) {
                entity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 25));
            }
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new JMonsterEntity.AnimatedAttackGoal(this, 1.0, false));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new IdleHealGoal((Mob)this, 4800));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new AttackWhenDifficultGoal((Mob)this, this));
        this.goalSelector.addGoal(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, null));
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 900.0).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.MOVEMENT_SPEED, 0.26).build();
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 5, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.MOVING);
            }
            return state.setAndContinue(this.IDLE);
        }));
    }

    @Override
    public boolean wantsToAttack(LivingEntity target, LivingEntity living) {
        return this.level().getDifficulty() != Difficulty.PEACEFUL;
    }

    @Override
    @Nullable
    protected BossCrystal.Type getDeathCrystalType() {
        return BossCrystal.Type.EUCA;
    }

    @Override
    public ResourceKey<LootTable> lootTable() {
        return JLootTables.EUDOR_CRYSTAL;
    }

    @Override
    public boolean showBarWhenSpawned() {
        return true;
    }
}

