/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.corba;

import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.entity.base.JFlyingEntity;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;

public class OverseerElder
extends JFlyingEntity {
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.overseer_elder.idle");

    public OverseerElder(EntityType<? extends JFlyingEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setKnowledge(EnumKnowledge.CORBA, 5.0f);
    }

    @Override
    public void addGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new ShootFireballGoal(this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, e -> Math.abs(e.getY() - this.getY()) <= 4.0));
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)JSounds.OVERSEER.get();
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)JSounds.OVERSEER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)JSounds.OVERSEER_DEATH.get();
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 68.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.MOVEMENT_SPEED, 0.26).build();
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 5, state -> state.setAndContinue(this.IDLE)));
    }

    @Override
    public boolean despawnInPeaceful() {
        return true;
    }

    protected float getSoundVolume() {
        return 2.5f;
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }

    public static boolean checkSpawn(EntityType<OverseerElder> entity, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.getDifficulty() != Difficulty.PEACEFUL && random.nextInt(10) == 0 && OverseerElder.checkMobSpawnRules(entity, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public static class ShootFireballGoal
    extends Goal {
        private final OverseerElder seer;
        public int chargeTime;

        public ShootFireballGoal(OverseerElder pseer) {
            this.seer = pseer;
        }

        public boolean canUse() {
            return this.seer.getTarget() != null;
        }

        public void start() {
            this.chargeTime = 0;
        }

        public void stop() {
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity livingentity = this.seer.getTarget();
            if (livingentity != null) {
                if (livingentity.distanceToSqr((Entity)this.seer) < 4096.0 && this.seer.hasLineOfSight((Entity)livingentity)) {
                    Level level = this.seer.level();
                    --this.chargeTime;
                    if (this.chargeTime == 10 && !this.seer.isSilent()) {
                        level.levelEvent(null, 1015, this.seer.blockPosition(), 0);
                    }
                    if (this.chargeTime == 20) {
                        Vec3 vec3 = this.seer.getViewVector(1.0f);
                        double d2 = livingentity.getX() - (this.seer.getX() + vec3.x * 4.0);
                        double d3 = livingentity.getY(0.5) - (0.5 + this.seer.getY(0.5));
                        double d4 = livingentity.getZ() - (this.seer.getZ() + vec3.z * 4.0);
                        Vec3 vec31 = new Vec3(d2, d3, d4);
                        if (!this.seer.isSilent()) {
                            level.levelEvent(null, 1016, this.seer.blockPosition(), 0);
                        }
                        SmallFireball fireball = new SmallFireball(level, (LivingEntity)this.seer, vec31.normalize());
                        fireball.setPos(this.seer.getX() + vec3.x * 4.0, this.seer.getY(0.5) + 0.5, fireball.getZ() + vec3.z * 4.0);
                        level.addFreshEntity((Entity)fireball);
                        this.chargeTime = -40;
                    }
                } else if (this.chargeTime > 0) {
                    --this.chargeTime;
                }
            }
        }
    }
}

