/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.corba;

import java.util.EnumSet;
import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.entity.base.JFlyingEntity;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animation.AnimatableManager;

public class SwampFly
extends JFlyingEntity {
    public SwampFly(EntityType<? extends JFlyingEntity> type, Level worldIn) {
        super(type, worldIn);
        this.setKnowledge(EnumKnowledge.CORBA, 2.0f);
        this.moveControl = new FlyMoveHelperController(this);
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.MOVEMENT_SPEED, 0.26).build();
    }

    public int getMaxSpawnClusterSize() {
        return 10;
    }

    @NotNull
    public InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.is(Items.GLASS_BOTTLE)) {
            player.playSound((SoundEvent)JSounds.BOTTLE_PLUG.get(), 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.createFilledResult((ItemStack)itemstack, (Player)player, (ItemStack)((Block)JBlocks.SWAMP_LAMP.get()).asItem().getDefaultInstance());
            player.setItemInHand(hand, itemstack1);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(5, (Goal)new FlyRandomFlyGoal(this, 0.2));
        this.goalSelector.addGoal(7, (Goal)new LookAroundGoal(this));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(2, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    public void addGoals() {
    }

    @Override
    public boolean despawnInPeaceful() {
        return false;
    }

    static class FlyMoveHelperController
    extends MoveControl {
        private final JFlyingEntity entity;
        private int floatDuration;

        public FlyMoveHelperController(JFlyingEntity entity) {
            super((Mob)entity);
            this.entity = entity;
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
                this.floatDuration += this.entity.getRandom().nextInt(3) + 1;
                Vec3 vector3d = new Vec3(this.wantedX - this.entity.getX(), this.wantedY - this.entity.getY(), this.wantedZ - this.entity.getZ());
                double d0 = vector3d.length();
                if (this.canReach(vector3d = vector3d.normalize(), Mth.ceil((double)d0))) {
                    this.entity.setDeltaMovement(this.entity.getDeltaMovement().add(vector3d.scale(0.1)));
                } else {
                    this.operation = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean canReach(Vec3 vector3d_, int int_) {
            AABB a = this.entity.getBoundingBox();
            for (int i = 1; i < int_; ++i) {
                a = a.move(vector3d_);
                if (this.entity.level().noCollision((Entity)this.entity, a)) continue;
                return false;
            }
            return true;
        }
    }

    static class FlyRandomFlyGoal
    extends Goal {
        private final JFlyingEntity entity;
        public final double speed;

        public FlyRandomFlyGoal(JFlyingEntity entity, double speed) {
            this.entity = entity;
            this.speed = speed;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            double d2;
            double d1;
            MoveControl m = this.entity.getMoveControl();
            if (!m.hasWanted()) {
                return true;
            }
            double d0 = m.getWantedX() - this.entity.getX();
            double d3 = d0 * d0 + (d1 = m.getWantedY() - this.entity.getY()) * d1 + (d2 = m.getWantedZ() - this.entity.getZ()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void start() {
            RandomSource random = this.entity.getRandom();
            double d0 = this.entity.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.entity.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 8.0f);
            double d2 = this.entity.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.entity.getMoveControl().setWantedPosition(d0, d1, d2, this.speed);
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final JFlyingEntity entity;

        public LookAroundGoal(JFlyingEntity entity) {
            this.entity = entity;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return true;
        }

        public void tick() {
            Vec3 vector3d = this.entity.getDeltaMovement();
            this.entity.setYRot(-((float)Mth.atan2((double)vector3d.x, (double)vector3d.z)) * 57.295776f);
            this.entity.yBodyRot = this.entity.getYRot();
        }
    }
}

