/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.euca.npc;

import net.jitl.client.ChatUtils;
import net.jitl.common.block.entity.PedestalTile;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RoyalKing
extends PathfinderMob
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> DATA_IS_ACTIVATED = SynchedEntityData.defineId(RoyalKing.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_HAS_CROWN = SynchedEntityData.defineId(RoyalKing.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.royal_king.idle");

    public RoyalKing(EntityType<? extends RoyalKing> entityType, Level world) {
        super(entityType, world);
    }

    protected void registerGoals() {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 5, state -> state.setAndContinue(this.IDLE)));
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.MOVEMENT_SPEED, 0.26).build();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void tick() {
        super.tick();
        if (this.isActivated() && !this.level().isClientSide) {
            if (this.hasCrown()) {
                this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.position().x + 0.5, this.position().y + (double)1.4f, this.position().z + 0.5, new ItemStack((ItemLike)JItems.EUDOR_CROWN.get(), 1)));
            }
            this.setHasCrown(false);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_IS_ACTIVATED, (Object)false);
        pBuilder.define(DATA_HAS_CROWN, (Object)true);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("activated", ((Boolean)this.entityData.get(DATA_IS_ACTIVATED)).booleanValue());
        compound.putBoolean("hasCrown", ((Boolean)this.entityData.get(DATA_HAS_CROWN)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setActivated(compound.getBoolean("activated"));
        this.setHasCrown(compound.getBoolean("hasCrown"));
    }

    public void setActivated(boolean activated) {
        this.entityData.set(DATA_IS_ACTIVATED, (Object)activated);
    }

    public void setHasCrown(boolean activated) {
        this.entityData.set(DATA_HAS_CROWN, (Object)activated);
    }

    public boolean isActivated() {
        return (Boolean)this.entityData.get(DATA_IS_ACTIVATED);
    }

    public boolean hasCrown() {
        return (Boolean)this.entityData.get(DATA_HAS_CROWN);
    }

    protected InteractionResult mobInteract(Player playerEntity, InteractionHand hand) {
        int check_radius = 10;
        int totalRoyalDisks = 0;
        int totalMetalDisks = 0;
        int totalTablets = 0;
        int neededRoyalDisks = 4;
        int neededMetalDisks = 2;
        int neededTables = 8;
        Level world = this.level();
        BlockPos entityPos = BlockPos.containing((Position)this.position());
        for (int x = -check_radius; x <= check_radius; ++x) {
            for (int z = -check_radius; z <= check_radius; ++z) {
                for (int y = -check_radius; y <= check_radius; ++y) {
                    PedestalTile tile;
                    BlockPos pos = entityPos.offset(x, y, z);
                    Block block = world.getBlockState(pos).getBlock();
                    if (block != JBlocks.ROYAL_PEDESTAL.get() || (tile = (PedestalTile)world.getBlockEntity(pos)) == null) continue;
                    if (tile.getItem(0).getItem().equals(JItems.ROYAL_DISK.get())) {
                        ++totalRoyalDisks;
                        --neededRoyalDisks;
                    }
                    if (tile.getItem(0).getItem().equals(JItems.METAL_DISK.get())) {
                        ++totalMetalDisks;
                        --neededMetalDisks;
                    }
                    if (tile.getItem(0).getItem().equals(JItems.EUCA_TABLET.get())) {
                        ++totalTablets;
                        --neededTables;
                    }
                    if (!this.isActivated()) continue;
                    tile.setItem(0, ItemStack.EMPTY);
                }
            }
        }
        if (totalRoyalDisks >= 4 && totalTablets >= 8 && totalMetalDisks >= 2) {
            this.playSound((SoundEvent)JSounds.COIN_PICKUP.get(), 1.5f, 1.0f);
            this.setActivated(true);
        }
        if (this.hasCrown()) {
            ChatUtils.addDialogStyleChat(playerEntity, "I need " + neededRoyalDisks + " more Royal Disks, " + neededMetalDisks + " Metal Disks and " + neededTables + " Euca Tablets");
        }
        if (!this.hasCrown()) {
            ChatUtils.addDialogStyleChat(playerEntity, "jitl.king.hero");
        }
        return super.mobInteract(playerEntity, hand);
    }
}

