/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.frozen;

import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.entity.base.JNeutralMonster;
import net.jitl.core.helper.MathHelper;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animation.AnimatableManager;

public class FrozenTrollEntity
extends JNeutralMonster {
    private static final EntityDataAccessor<Boolean> IS_ANGRY_ID = SynchedEntityData.defineId(FrozenTrollEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public FrozenTrollEntity(EntityType<? extends FrozenTrollEntity> entityType, Level world) {
        super(entityType, world);
        this.setCanPickUpLoot(true);
        this.setKnowledge(EnumKnowledge.FROZEN, 5.0f);
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 42.0).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.MOVEMENT_SPEED, 0.26).build();
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("angry", ((Boolean)this.entityData.get(IS_ANGRY_ID)).booleanValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setAngry(compound.getBoolean("angry"));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(IS_ANGRY_ID, (Object)false);
    }

    public boolean isAngry() {
        return (Boolean)this.entityData.get(IS_ANGRY_ID);
    }

    public void setAngry(boolean angry) {
        this.entityData.set(IS_ANGRY_ID, (Object)angry);
    }

    protected void customServerAiStep() {
        boolean isPresent = this.getTarget() != null;
        this.entityData.set(IS_ANGRY_ID, (Object)isPresent);
        super.customServerAiStep();
    }

    public void playSound(SoundEvent soundEvent_) {
        this.playSound(soundEvent_, this.getSoundVolume(), this.getVoicePitch());
    }

    public boolean doHurtTarget(@NotNull Entity entityIn) {
        if (super.doHurtTarget(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                entityIn.setDeltaMovement(entityIn.getDeltaMovement().add((double)(-MathHelper.sin((float)(this.lerpYRot * Math.PI / 180.0)) * 2.0f), 0.1, (double)(MathHelper.cos((float)(this.lerpYRot * Math.PI / 180.0)) * 2.0f)));
            }
            return true;
        }
        return false;
    }

    public void playAmbientSound() {
        if (this.isAngry()) {
            this.playSound(this.getAngryAmbientSound(), this.getSoundVolume(), this.getVoicePitch());
        } else {
            this.playSound(this.getCuteAmbientSound(), this.getSoundVolume(), this.getVoicePitch() + 1.0f);
        }
    }

    protected SoundEvent getCuteAmbientSound() {
        return (SoundEvent)JSounds.FROZEN_TROLL_INTRIGUED.get();
    }

    protected SoundEvent getAngryAmbientSound() {
        return (SoundEvent)JSounds.FROZEN_TROLL_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource damageSourceIn) {
        return (SoundEvent)JSounds.FROZEN_TROLL_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)JSounds.FROZEN_TROLL_DEATH.get();
    }

    protected void playStepSound(@NotNull BlockPos pos, @NotNull BlockState blockIn) {
        this.playSound(SoundEvents.WOLF_STEP, 0.15f, 1.0f);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }
}

