/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.frozen.npc;

import net.jitl.client.ChatUtils;
import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.block.entity.PedestalTile;
import net.jitl.common.capability.stats.PlayerStats;
import net.jitl.common.entity.projectile.EssenciaBoltEntity;
import net.jitl.common.items.LoreScrollItem;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JDataAttachments;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JSounds;
import net.jitl.core.init.internal.ScrollEntries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FrozenGuardian
extends PathfinderMob
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> DATA_IS_ACTIVATED = SynchedEntityData.defineId(FrozenGuardian.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int death_timer = 50;
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.frozen_guardian.idle");

    public FrozenGuardian(EntityType<? extends FrozenGuardian> entityType, Level world) {
        super(entityType, world);
    }

    protected void registerGoals() {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 5, state -> state.setAndContinue(this.IDLE)));
    }

    public static AttributeSupplier createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).build();
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void tick() {
        super.tick();
        if (this.isActivated()) {
            --this.death_timer;
            this.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, this.getX() - 0.5 + this.random.nextDouble(), this.getY() + 0.5 + this.random.nextDouble(), this.getZ() - 0.5 + this.random.nextDouble(), this.random.nextGaussian() * 0.05, 0.15, this.random.nextGaussian() * 0.05);
            if (this.death_timer <= 0) {
                for (int i = 0; i < 24; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, this.getX() - Mth.nextDouble((RandomSource)this.random, (double)-0.45, (double)0.75), this.getY() + Mth.nextDouble((RandomSource)this.random, (double)0.5, (double)2.0), this.getZ() - Mth.nextDouble((RandomSource)this.random, (double)-0.45, (double)0.75), this.random.nextGaussian() * 0.05, 0.15, this.random.nextGaussian() * 0.05);
                }
                this.playSound(SoundEvents.FIRE_EXTINGUISH, 1.0f, 1.0f);
                this.remove(Entity.RemovalReason.DISCARDED);
                if (!this.level().isClientSide) {
                    ItemStack scrollStack = new ItemStack((ItemLike)JItems.LORE_SCROLL.asItem());
                    LoreScrollItem.bindScrollEntry(scrollStack, ScrollEntries.FROZEN_DESPAIR, EnumKnowledge.FROZEN, 25);
                    this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.position().x + 0.5, this.position().y + (double)1.4f, this.position().z + 0.5, scrollStack));
                }
                this.death_timer = 100;
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_IS_ACTIVATED, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("activated", ((Boolean)this.entityData.get(DATA_IS_ACTIVATED)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setActivated(compound.getBoolean("activated"));
    }

    public void setActivated(boolean activated) {
        this.entityData.set(DATA_IS_ACTIVATED, (Object)activated);
    }

    public boolean isActivated() {
        return (Boolean)this.entityData.get(DATA_IS_ACTIVATED);
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean canBeLeashed() {
        return false;
    }

    public boolean isAttackable() {
        return false;
    }

    public void push(Entity entity) {
    }

    protected void doPush(Entity entityIn) {
    }

    public boolean isPushable() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public boolean fireImmune() {
        return true;
    }

    protected InteractionResult mobInteract(Player playerEntity, InteractionHand hand) {
        int check_radius = 8;
        int totalPedestals = 0;
        Level world = this.level();
        BlockPos entityPos = BlockPos.containing((Position)this.position());
        for (int x = -check_radius; x <= check_radius; ++x) {
            for (int z = -check_radius; z <= check_radius; ++z) {
                for (int y = -check_radius; y <= check_radius; ++y) {
                    PedestalTile tile;
                    BlockPos pos = entityPos.offset(x, y, z);
                    Block block = world.getBlockState(pos).getBlock();
                    if (block != JBlocks.FROZEN_PEDESTAL.get() || (tile = (PedestalTile)world.getBlockEntity(pos)) == null || !tile.getItem(0).getItem().equals(JItems.FROSTBORN_SOUL.get())) continue;
                    if (this.isActivated()) {
                        if (!this.level().isClientSide) {
                            this.summonLightning(pos);
                            this.disableFrozenBlizzard();
                        }
                        tile.setItem(0, ItemStack.EMPTY);
                    }
                    ++totalPedestals;
                }
            }
        }
        if (totalPedestals >= 8) {
            this.playSound((SoundEvent)JSounds.FROZEN_GUARDIAN_DEATH.get(), 1.5f, 1.0f);
            ChatUtils.addDialogStyleChat(playerEntity, "jitl.npc.frozen_guardian1");
            this.setActivated(true);
        } else {
            ChatUtils.addDialogStyleChat(playerEntity, "jitl.npc.frozen_guardian2");
        }
        return super.mobInteract(playerEntity, hand);
    }

    public void summonLightning(BlockPos pos) {
        EssenciaBoltEntity bolt = new EssenciaBoltEntity((EntityType<? extends LightningBolt>)((EntityType)JEntities.ESSENCIA_BOLT_TYPE.get()), this.level());
        bolt.setPos(pos.getX(), (double)pos.getY() + 1.0, pos.getZ());
        bolt.setARGB(5950463);
        bolt.setVisualOnly(true);
        if (!this.level().isClientSide) {
            this.level().addFreshEntity((Entity)bolt);
        }
    }

    public void disableFrozenBlizzard() {
        int playerArea = 10;
        AABB axisalignedbb = AABB.unitCubeFromLowerCorner((Vec3)this.position()).inflate((double)playerArea);
        for (Player player : this.level().getEntitiesOfClass(Player.class, axisalignedbb)) {
            PlayerStats stats = (PlayerStats)player.getData(JDataAttachments.PLAYER_STATS);
            stats.setBlizzard(true);
            stats.setLevel(EnumKnowledge.FROZEN, 100);
        }
    }
}

