/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.overworld;

import java.util.EnumSet;
import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.entity.base.JMonsterEntity;
import net.jitl.common.entity.goal.FloroAttackGoal;
import net.jitl.common.entity.projectile.FloroMudEntity;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;

public class Floro
extends JMonsterEntity
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> HIDDEN = SynchedEntityData.defineId(Floro.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_SHOOTING = SynchedEntityData.defineId(Floro.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_SHOWING = SynchedEntityData.defineId(Floro.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private boolean isHiding = false;
    private final RawAnimation MOVING = RawAnimation.begin().thenLoop("animation.floro.walk");
    private final RawAnimation HIDDEN_ANIM = RawAnimation.begin().thenLoop("animation.floro.hidden");
    private final RawAnimation SHOWING = RawAnimation.begin().thenLoop("animation.floro.showing");
    private final RawAnimation ATTACK = RawAnimation.begin().thenLoop("animation.floro.shoot");
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.floro.idle");

    public Floro(EntityType<? extends Monster> type, Level world) {
        super(type, world);
        this.setKnowledge(EnumKnowledge.OVERWORLD, 5.0f);
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 5, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.MOVING);
            }
            if (this.isHidden()) {
                return state.setAndContinue(this.HIDDEN_ANIM);
            }
            if (this.isShooting()) {
                return state.setAndContinue(this.ATTACK);
            }
            if (this.isShowing()) {
                return state.setAndContinue(this.SHOWING);
            }
            return state.setAndContinue(this.IDLE);
        }));
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        this.setHidden(false);
        return super.hurt(pSource, pAmount);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(HIDDEN, (Object)true);
        pBuilder.define(IS_SHOOTING, (Object)false);
        pBuilder.define(IS_SHOWING, (Object)false);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("hidden", this.isHidden());
        compound.putBoolean("shooting", this.isShooting());
        compound.putBoolean("showing", this.isShowing());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("hidden")) {
            this.setHidden(compound.getBoolean("hidden"));
        }
        if (compound.contains("shooting")) {
            this.setShooting(compound.getBoolean("shooting"));
        }
    }

    public void onAddedToLevel() {
        if (this.isEffectiveAi() && this.isHidden()) {
            this.setHidden(true);
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloroRevealingGoal());
        this.goalSelector.addGoal(2, (Goal)new FloroHidingGoal());
        this.goalSelector.addGoal(3, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(5, (Goal)new FloroAttackGoal(this, 1.0, 20, 15.0f));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 5, true, false, null));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Bee.class, 5, true, false, null));
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 25.0).add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.MOVEMENT_SPEED, 0.26).build();
    }

    public void aiStep() {
        if (this.isEffectiveAi()) {
            if (this.isHidden()) {
                this.isHiding = false;
            }
            if (this.canMove()) {
                this.goalSelector.enableControlFlag(Goal.Flag.LOOK);
                this.goalSelector.enableControlFlag(Goal.Flag.JUMP);
            } else {
                this.goalSelector.disableControlFlag(Goal.Flag.LOOK);
                this.goalSelector.disableControlFlag(Goal.Flag.JUMP);
            }
        }
        super.aiStep();
    }

    public void push(double x, double y, double z) {
        if (this.canMove()) {
            super.push(x, y, z);
        } else {
            super.push(0.0, 0.0, 0.0);
        }
    }

    public void knockback(double strength, double ratioX, double ratioZ) {
        if (this.canMove()) {
            super.knockback(strength, ratioX, ratioZ);
        }
    }

    private boolean canMove() {
        return !this.isHidden() && !this.isHiding;
    }

    public boolean isHidden() {
        return (Boolean)this.getEntityData().get(HIDDEN);
    }

    public boolean isShooting() {
        return (Boolean)this.getEntityData().get(IS_SHOOTING);
    }

    public boolean isShowing() {
        return (Boolean)this.getEntityData().get(IS_SHOWING);
    }

    public void setHidden(boolean value) {
        this.getEntityData().set(HIDDEN, (Object)value);
    }

    public void setShooting(boolean value) {
        this.getEntityData().set(IS_SHOOTING, (Object)value);
    }

    public void setShowing(boolean value) {
        this.getEntityData().set(IS_SHOWING, (Object)value);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)JSounds.HONGO_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)JSounds.HONGO_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)JSounds.HONGO_DEATH.get();
    }

    public void performRangedAttack(LivingEntity pTarget, float pVelocity) {
        FloroMudEntity mud = new FloroMudEntity(this.level(), (LivingEntity)this, 3.5f);
        double d0 = pTarget.getEyeY() - (double)1.1f;
        double d1 = pTarget.getX() - this.getX();
        double d2 = d0 - mud.getY();
        double d3 = pTarget.getZ() - this.getZ();
        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        mud.shoot(d1, d2 + d4, d3, 1.6f, 12.0f);
        this.playSound(SoundEvents.SNOW_GOLEM_SHOOT, 1.0f, 0.4f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)mud);
    }

    private class FloroRevealingGoal
    extends Goal {
        public FloroRevealingGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return !Floro.this.canMove() && Floro.this.getTarget() != null;
        }

        public void start() {
            if (Floro.this.isHidden()) {
                Floro.this.setShowing(true);
            } else {
                Floro.this.setHidden(false);
            }
        }

        public boolean isInterruptable() {
            return false;
        }
    }

    private class FloroHidingGoal
    extends Goal {
        public FloroHidingGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return !Floro.this.isHidden() && Floro.this.getTarget() == null;
        }

        public boolean canContinueToUse() {
            return !Floro.this.isHidden();
        }

        public void start() {
            Floro.this.isHiding = true;
        }

        public void tick() {
            if (!Floro.this.isHidden() && Floro.this.tickCount % 240 == 0) {
                Floro.this.setHidden(true);
            }
        }

        public void stop() {
            Floro.this.isHiding = false;
        }
    }
}

