/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.overworld;

import net.jitl.common.entity.base.JTamableEntity;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;

public class PetRobot
extends JTamableEntity {
    private final RawAnimation MOVING = RawAnimation.begin().thenLoop("animation.pet_robot.walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.pet_robot.idle");
    private final RawAnimation SIT = RawAnimation.begin().thenPlayAndHold("animation.pet_robot.sit");

    public PetRobot(EntityType<? extends JTamableEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public PetRobot(EntityType<? extends JTamableEntity> pEntityType, Level pLevel, Player player) {
        super(pEntityType, pLevel);
        this.setOwnerUUID(player.getUUID());
        this.setTame(true, true);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)JSounds.ROBOT.get();
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)JSounds.ROBOT_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)JSounds.ROBOT_DEATH.get();
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.MOVEMENT_SPEED, 0.35).build();
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 5, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.MOVING);
            }
            if (this.isInSittingPose()) {
                return state.setAndContinue(this.SIT);
            }
            return state.setAndContinue(this.IDLE);
        }));
    }

    @Override
    public int setBaseHealth() {
        return 40;
    }

    @Override
    public int setTameHealth() {
        return 40;
    }

    @Override
    public Item getTameItem() {
        return (Item)JItems.PET_FOOD.get();
    }
}

