/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.overworld.npc;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import net.jitl.client.ChatUtils;
import net.jitl.common.entity.base.CurrencyForItemsTrade;
import net.jitl.common.entity.base.JVillagerEntity;
import net.jitl.common.entity.base.JVillagerMob;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;

public class RockiteGolem
extends JVillagerEntity {
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> TRADES = new Int2ObjectOpenHashMap((Map)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new CurrencyForItemsTrade((ItemLike)JItems.REINFORCED_CRYSTAL_INGOT, 4, (ItemLike)Items.BLAZE_POWDER, 8, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.REINFORCED_STONE_INGOT, 4, (ItemLike)JItems.BACK_BITER, 1, (ItemLike)JItems.CRYSTALLIZED_BATTLE_AXE, 1, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.REINFORCED_CRYSTAL_INGOT, 4, (ItemLike)JItems.EARTHEN_HAMMER, 1, (ItemLike)JItems.CRYSTALLIZED_HAMMER, 1, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.REINFORCED_STONE_INGOT, 4, (ItemLike)JItems.EARTHEN_HAMMER, 1, (ItemLike)JItems.ROCKY_HAMMER, 1, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.REINFORCED_STONE_INGOT, 4, (ItemLike)JItems.STONE_CLUMP, 4, (ItemLike)JItems.ROCK_LAUNCHER, 1, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.REINFORCED_CRYSTAL_INGOT, 4, (ItemLike)JItems.STAFF_OF_ENLIGHTENMENT, 1, (ItemLike)JItems.STAFF_OF_DIVINITY, 1, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.REINFORCED_CRYSTAL_INGOT, 4, (ItemLike)JItems.STAFF_OF_DIVINITY, 1, (ItemLike)JItems.CRYSTAL_STAFF, 1, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.REINFORCED_STONE_INGOT, 4, (ItemLike)JItems.BRONZED_BATTLE_AXE, 1, (ItemLike)JItems.ROCKY_BATTLE_AXE, 1, 99, 5)}));
    private final RawAnimation MOVING = RawAnimation.begin().thenLoop("animation.rockite_golem.walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.rockite_golem.idle");

    public RockiteGolem(EntityType<? extends JVillagerEntity> type, Level worldIn) {
        super((EntityType<? extends JVillagerMob>)type, worldIn);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.MOVEMENT_SPEED, 0.26).build();
    }

    public static boolean checkSpawn(EntityType<RockiteGolem> entity, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return (double)pos.getY() < 40.0 && RockiteGolem.checkMobSpawnRules(entity, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    @Override
    @NotNull
    public InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand playerHand) {
        ChatUtils.addDialogStyleChat(player, "jitl.trader.rockite_golem");
        return super.mobInteract(player, playerHand);
    }

    @Override
    protected Int2ObjectMap<VillagerTrades.ItemListing[]> getVillagerTrades() {
        return TRADES;
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 5, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.MOVING);
            }
            return state.setAndContinue(this.IDLE);
        }));
    }

    protected void rewardTradeXp(MerchantOffer merchantOffer) {
    }

    protected void updateTrades() {
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }
}

