/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.projectile;

import java.util.List;
import net.jitl.common.entity.projectile.JThrowableProjectile;
import net.jitl.core.init.internal.JParticleManager;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractHomingEntity
extends JThrowableProjectile {
    private LivingEntity target = null;

    public AbstractHomingEntity(EntityType<? extends AbstractHomingEntity> type, Level world) {
        super(type, world);
    }

    public AbstractHomingEntity(EntityType<? extends ThrowableProjectile> e, int damage, Level world, LivingEntity thrower) {
        super(e, damage, world, thrower);
    }

    public void tick() {
        super.tick();
        List mobs = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate((double)this.getHomingRadius(), (double)this.getHomingRadius(), (double)this.getHomingRadius()));
        boolean findNewTarget = this.target == null || this.target.isDeadOrDying();
        for (int i = 0; i < 4; ++i) {
            this.level().addParticle((ParticleOptions)JParticleManager.WIZARDS_STAR.get(), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
        for (LivingEntity e : mobs) {
            if (e == this.getOwner()) continue;
            float targetDist = this.target == null ? 0.0f : this.distanceTo((Entity)this.target);
            float compareDist = this.distanceTo((Entity)e);
            if (!findNewTarget || this.target != null && !(compareDist < targetDist)) continue;
            this.target = e;
        }
        if (this.target != null) {
            Vec3 dir = new Vec3(this.target.xo - this.xo, this.target.yo + (double)this.target.getEyeHeight() - this.yo, this.target.zo - this.zo).normalize();
            this.setDeltaMovement(dir.x / 1.25, dir.y / 1.25, dir.z / 1.25);
        }
        if (this.tickCount > 100) {
            this.discard();
        }
    }

    public abstract int getHomingRadius();

    public boolean isNoGravity() {
        return true;
    }
}

