/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.projectile;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class DamagingProjectileEntity
extends ThrowableProjectile {
    private float damage;

    public DamagingProjectileEntity(EntityType<? extends DamagingProjectileEntity> type, Level world) {
        super(type, world);
    }

    public DamagingProjectileEntity(EntityType<? extends DamagingProjectileEntity> type, Level world, LivingEntity thrower, float damage) {
        super(type, thrower, world);
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.shouldDespawn()) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        } else {
            this.onClientTick();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick() {
    }

    protected boolean shouldDespawn() {
        return this.tickCount >= 200;
    }

    protected void onHit(HitResult result) {
        if (!this.level().isClientSide) {
            if (result.getType() == HitResult.Type.ENTITY) {
                Entity target = ((EntityHitResult)result).getEntity();
                if (!Objects.equals(target, this.getOwner())) {
                    this.onEntityImpact(result, target);
                    this.remove(Entity.RemovalReason.DISCARDED);
                }
            } else if (result.getType() == HitResult.Type.BLOCK) {
                this.onBlockImpact((BlockHitResult)result);
            } else {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    protected void onEntityImpact(HitResult result, Entity target) {
        target.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), this.getDamage());
    }

    protected void onBlockImpact(BlockHitResult result) {
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    protected double getDefaultGravity() {
        return 0.03f;
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("damage", this.damage);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.damage = compound.getFloat("damage");
    }
}

