/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.projectile;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class EssenceArrowEntity
extends AbstractArrow {
    private EnumSet<BowEffects> effects;
    private static final ItemStack DEFAULT_ARROW_STACK = new ItemStack((ItemLike)JItems.ESSENCE_ARROW.get());

    public EssenceArrowEntity(EntityType<? extends AbstractArrow> type, Level level) {
        super(type, level);
    }

    public EssenceArrowEntity(Level pLevel, LivingEntity pOwner, @Nullable ItemStack pFiredFromWeapon) {
        super((EntityType)JEntities.ESSENCE_ARROW_TYPE.get(), pOwner, pLevel, DEFAULT_ARROW_STACK, pFiredFromWeapon);
    }

    public EssenceArrowEntity(Level pLevel, double pX, double pY, double pZ, @Nullable ItemStack pFiredFromWeapon) {
        super((EntityType)JEntities.ESSENCE_ARROW_TYPE.get(), pX, pY, pZ, pLevel, DEFAULT_ARROW_STACK, pFiredFromWeapon);
    }

    public EssenceArrowEntity(Level level, LivingEntity player, EnumSet<BowEffects> effects, float damage, @Nullable ItemStack weapon) {
        super((EntityType)JEntities.ESSENCE_ARROW_TYPE.get(), player, level, DEFAULT_ARROW_STACK, weapon);
        this.effects = effects;
        this.setBaseDamage(damage);
        this.setPickupItemStack(DEFAULT_ARROW_STACK);
    }

    protected void onHitEntity(@NotNull EntityHitResult r) {
        super.onHitEntity(r);
        Entity entity = r.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (this.effects != null) {
                if (this.effects.contains((Object)BowEffects.WITHER)) {
                    this.applyPotionEffect(entity2, (Holder<MobEffect>)MobEffects.WITHER, 100, 2);
                }
                if (this.effects.contains((Object)BowEffects.SLOWNESS)) {
                    this.applyPotionEffect(entity2, (Holder<MobEffect>)MobEffects.MOVEMENT_SLOWDOWN, 100, 2);
                }
                if (this.effects.contains((Object)BowEffects.FLAME)) {
                    entity2.setRemainingFireTicks(60);
                }
                if (this.effects.contains((Object)BowEffects.POISON)) {
                    this.applyPotionEffect(entity2, (Holder<MobEffect>)MobEffects.POISON, 100, 2);
                }
            }
        }
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)JItems.ESSENCE_ARROW.get());
    }

    private void applyPotionEffect(LivingEntity effectedEntity, Holder<MobEffect> potionEffect, int duration, int amplifier) {
        effectedEntity.addEffect(new MobEffectInstance(potionEffect, duration, amplifier));
    }

    protected boolean tryPickup(Player pPlayer) {
        return !this.effects.contains((Object)BowEffects.CONSUMES_ESSENCE);
    }

    public static enum BowEffects {
        WITHER,
        SLOWNESS,
        FLAME,
        POISON,
        DOUBLE_ARROW,
        CONSUMES_ESSENCE;

    }
}

