/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.projectile;

import net.jitl.common.entity.projectile.DamagingProjectileEntity;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class FireBombEntity
extends DamagingProjectileEntity
implements ItemSupplier {
    public FireBombEntity(EntityType<FireBombEntity> type, Level world) {
        super(type, world);
    }

    public FireBombEntity(EntityType<FireBombEntity> type, Level world, LivingEntity thrower, float damage) {
        super(type, world, thrower, damage);
    }

    @Override
    protected void onEntityImpact(HitResult result, Entity target) {
        if (target instanceof LivingEntity && target.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), this.getDamage())) {
            target.hurt(this.damageSources().cactus(), this.getDamage());
            target.setRemainingFireTicks(60);
            if (!this.level().isClientSide) {
                this.level().broadcastEntityEvent((Entity)this, (byte)1);
                this.discard();
            }
        }
    }

    public void handleEntityEvent(byte id) {
        int i;
        SimpleParticleType particleoptions = ParticleTypes.EFFECT;
        if (id == 1) {
            for (i = 0; i < 15; ++i) {
                this.level().addParticle((ParticleOptions)particleoptions, this.getX() + this.level().random.nextDouble(), this.getY(), this.getZ() + this.level().random.nextDouble(), 1.0, 0.0, 0.0);
            }
        }
        if (id == 2) {
            for (i = 0; i < 15; ++i) {
                this.level().addParticle((ParticleOptions)particleoptions, this.getX() + this.level().random.nextDouble(), this.getY() + 1.0, this.getZ() + this.level().random.nextDouble(), 1.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void onHit(HitResult result) {
        super.onHit(result);
        if (result.getType() == HitResult.Type.BLOCK && !this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)2);
            this.discard();
        }
    }

    @NotNull
    public ItemStack getItem() {
        return new ItemStack((ItemLike)JItems.FIRE_BOMB.get());
    }
}

