/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.projectile;

import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JParticleManager;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class FireballEntity
extends ThrowableProjectile {
    public FireballEntity(EntityType<FireballEntity> type, Level world) {
        super(type, world);
    }

    public FireballEntity(Level world, LivingEntity thrower) {
        super((EntityType)JEntities.FIREBALL_TYPE.get(), thrower, world);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte pId) {
        if (pId == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)JParticleManager.HELLSTONE.get(), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHitEntity(EntityHitResult pResult) {
        super.onHitEntity(pResult);
        Entity entity = pResult.getEntity();
        if (entity instanceof LivingEntity && entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), this.getDamage())) {
            entity.setRemainingFireTicks(20);
            entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), this.getDamage());
        }
    }

    private float getDamage() {
        return 5.0f;
    }

    protected void onHit(HitResult pResult) {
        super.onHit(pResult);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }

    protected double getDefaultGravity() {
        return 0.003f;
    }
}

