/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.projectile;

import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public abstract class JThrowableProjectile
extends ThrowableProjectile {
    private int damage = 0;
    private int fireTicks = 0;
    private int potionTicks = 0;
    private boolean isBouncy = false;
    private boolean isFire = false;
    private boolean isPotion = false;
    private Holder<MobEffect> potion;

    protected JThrowableProjectile(EntityType<? extends ThrowableProjectile> e, Level l) {
        super(e, l);
    }

    public JThrowableProjectile(EntityType<? extends ThrowableProjectile> e, int damage, Level world, LivingEntity thrower) {
        super(e, thrower, world);
        this.damage = damage;
    }

    public void setPotionEffect(Holder<MobEffect> potion, int ticks) {
        this.isPotion = true;
        this.potionTicks = ticks;
        this.potion = potion;
    }

    public void setFire(int fireTicks) {
        this.isFire = true;
        this.fireTicks = fireTicks;
    }

    public void setBouncy() {
        this.isBouncy = true;
    }

    protected void onHitEntity(@NotNull EntityHitResult res) {
        super.onHitEntity(res);
        Entity entity = res.getEntity();
        if (entity instanceof LivingEntity) {
            if (this.isPotion && this.potion != null) {
                MobEffectInstance effectInstance = new MobEffectInstance(this.potion, this.potionTicks);
                ((LivingEntity)entity).addEffect(effectInstance);
            }
            if (this.damage != 0) {
                entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), (float)this.damage);
            }
            if (this.isFire) {
                entity.setRemainingFireTicks(this.fireTicks);
            }
        }
    }

    public int getEntityDamage() {
        return this.damage;
    }

    protected void onHit(@NotNull HitResult res) {
        super.onHit(res);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            if (!this.isBouncy) {
                this.discard();
            }
        }
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SynchedEntityData.Builder b) {
    }
}

