/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.projectile;

import java.util.List;
import javax.annotation.Nullable;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PiercerEntity
extends AbstractArrow
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.defineId(PiercerEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private float velocityMultiplier;
    private double rangeAddend;
    private int flameAddend;
    private int faithfulLevel;
    private boolean launch = false;
    private int currentBounces;
    private int maxBounces;
    public int soundTickCount;
    private static final ItemStack DEFAULT_ARROW_STACK = new ItemStack((ItemLike)JItems.ESSENCE_ARROW.get());

    public PiercerEntity(LivingEntity shooter, Level worldIn, ItemStack stack, int maxBounces, float damage, @Nullable ItemStack weapon) {
        super((EntityType)JEntities.PIERCER_TYPE.get(), shooter, worldIn, DEFAULT_ARROW_STACK, weapon);
        this.setStack(stack.copy());
        this.setSoundEvent((SoundEvent)JSounds.PIERCER.get());
        this.maxBounces = maxBounces;
        this.setBaseDamage(damage);
    }

    public PiercerEntity(EntityType<PiercerEntity> piercer, Level world) {
        super(piercer, world);
        this.setSoundEvent((SoundEvent)JSounds.PIERCER.get());
    }

    public void setVelocityMultiplier(float velocityMultiplier) {
        this.velocityMultiplier = velocityMultiplier;
    }

    public float getVelocityMultiplier() {
        return this.velocityMultiplier;
    }

    public void setRangeAddend(double rangeAddend) {
        this.rangeAddend = rangeAddend;
    }

    public double getRangeAddend() {
        return this.rangeAddend;
    }

    public void setFlameAddend(int flameAddend) {
        this.flameAddend = flameAddend;
    }

    public void setFaithfulLevel(int level) {
        this.faithfulLevel = level;
    }

    public int getFlameAddend() {
        return this.flameAddend;
    }

    public void tick() {
        super.tick();
        if (!(this.isNoPhysics() || this.isInGround() || this.isNoGravity())) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.025, 0.0));
        }
        if (this.launch) {
            Entity bounceTo = null;
            if (++this.currentBounces <= this.maxBounces) {
                List entitiesNear = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(4.0 + this.getRangeAddend()));
                for (LivingEntity e : entitiesNear) {
                    if (e == this.getOwner() || !this.pathTo((Entity)e) || e.invulnerableTime != 0 || e.isDeadOrDying() || e.getClassification(false) != MobCategory.MONSTER || bounceTo != null && !(this.distanceTo((Entity)e) < this.distanceTo(bounceTo))) continue;
                    bounceTo = e;
                }
            }
            if (bounceTo == null) {
                bounceTo = this.getOwner();
            }
            if (bounceTo != null) {
                Vec3 movement = new Vec3(bounceTo.getX(), bounceTo.getY(0.8), bounceTo.getZ()).subtract(this.getX(), this.getY(0.5), this.getZ());
                this.setDeltaMovement(movement.scale((0.7 + (double)this.getVelocityMultiplier() / 6.5) / movement.length() * this.getDeltaMovement().length()));
            }
            this.launch = false;
        }
        if (this.faithfulLevel > 0) {
            Entity entity = this.getOwner();
            if (this.isInGround() && this.isAcceptableReturnOwner() && entity != null) {
                this.setNoPhysics(true);
                Vec3 vector3d = new Vec3(entity.getX() - this.getX(), entity.getEyeY() - this.getY(), entity.getZ() - this.getZ());
                this.setPosRaw(this.getX(), this.getY() + vector3d.y * 0.015 * (double)this.faithfulLevel, this.getZ());
                if (this.level().isClientSide) {
                    this.yOld = this.getY();
                }
                double d0 = 0.15 * (double)this.faithfulLevel;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(vector3d.normalize().scale(d0)));
                if (this.soundTickCount == 0) {
                    this.playSound((SoundEvent)JSounds.PIERCER_RETURN.get(), 10.0f, Mth.nextFloat((RandomSource)this.random, (float)0.8f, (float)1.2f));
                }
                ++this.soundTickCount;
            }
        }
        if (this.getStack().isEmpty()) {
            this.level().playSound(null, this.blockPosition(), SoundEvents.ITEM_BREAK, SoundSource.AMBIENT, 1.0f, 1.0f);
            this.discard();
        }
    }

    private boolean isAcceptableReturnOwner() {
        Entity entity = this.getOwner();
        if (entity != null && entity.isAlive()) {
            return !(entity instanceof ServerPlayer) || !entity.isSpectator();
        }
        return false;
    }

    private boolean pathTo(Entity entityIn) {
        Vec3 vector3d = new Vec3(this.getX(), this.getY(0.5), this.getZ());
        Vec3 vector3d1 = new Vec3(entityIn.getX(), entityIn.getY(0.8), entityIn.getZ());
        return this.level().clip(new ClipContext(vector3d, vector3d1, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() == HitResult.Type.MISS;
    }

    protected void onHitEntity(EntityHitResult entityRayTraceResult_) {
        Entity entity = entityRayTraceResult_.getEntity();
        if (entity instanceof LivingEntity && entity != this.getOwner() && !this.level().isClientSide()) {
            Entity entity2 = this.getOwner();
            if (entity2 instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity2;
                this.getStack().hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
            if (entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), (float)this.getBaseDamage())) {
                if (this.getFlameAddend() > 0) {
                    entity.setRemainingFireTicks(this.getFlameAddend() * 4 * 20);
                }
                this.launch = true;
            }
            this.playSound((SoundEvent)JSounds.PIERCER.get(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        }
    }

    public void playerTouch(@NotNull Player entityIn) {
        if (!this.level().isClientSide) {
            boolean isOwner;
            boolean bl = isOwner = this.getOwner().getUUID() == entityIn.getUUID();
            if (isOwner && this.currentBounces > 0 || (this.inGround || this.isNoPhysics()) && this.shakeTime <= 0) {
                boolean flag;
                boolean bl2 = flag = this.pickup == AbstractArrow.Pickup.ALLOWED || this.pickup == AbstractArrow.Pickup.CREATIVE_ONLY && entityIn.canUseGameMasterBlocks() || this.isNoPhysics() && isOwner;
                if (this.pickup == AbstractArrow.Pickup.ALLOWED && !entityIn.getInventory().add(this.getPickupItem())) {
                    flag = false;
                }
                if (flag) {
                    entityIn.take((Entity)this, 1);
                    this.remove(Entity.RemovalReason.DISCARDED);
                }
            }
        }
    }

    public boolean isInGround() {
        return this.inGround;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.put("stack", this.getStack().save((HolderLookup.Provider)this.registryAccess()));
        nbt.putInt("bounces", this.currentBounces);
        nbt.putInt("maxBounces", this.maxBounces);
        nbt.putFloat("velocityMultiplier", this.velocityMultiplier);
        nbt.putDouble("rangeAddend", this.rangeAddend);
        nbt.putInt("flameAddend", this.flameAddend);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setStack(ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)nbt.getCompound("stack")).orElse(this.getDefaultPickupItem()));
        if (this.getStack().isEmpty()) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        this.currentBounces = nbt.getInt("bounces");
        this.maxBounces = nbt.getInt("maxBounces");
        this.velocityMultiplier = nbt.getFloat("velocityMultiplier");
        this.rangeAddend = nbt.getDouble("rangeAddend");
        this.flameAddend = nbt.getInt("flameAddend");
    }

    private void setStack(ItemStack stack) {
        this.getEntityData().set(STACK, (Object)stack);
    }

    private ItemStack getStack() {
        return (ItemStack)this.getEntityData().get(STACK);
    }

    @NotNull
    protected ItemStack getPickupItem() {
        return this.getStack().copy();
    }

    protected ItemStack getDefaultPickupItem() {
        return this.getPickupItem();
    }

    @NotNull
    public ItemStack getItem() {
        ItemStack stack = this.getStack();
        return stack.isEmpty() ? new ItemStack((ItemLike)JItems.PIERCER.get()) : stack;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(STACK, (Object)ItemStack.EMPTY);
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> key) {
        if (key == STACK) {
            this.getStack().setEntityRepresentation((Entity)this);
        }
        super.onSyncedDataUpdated(key);
    }
}

