/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.terrania;

import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.entity.base.JPathfinderMob;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animation.AnimatableManager;

public class Flungas
extends JPathfinderMob {
    public Flungas(EntityType<? extends Flungas> entityType, Level world) {
        super(entityType, world);
        this.setKnowledge(EnumKnowledge.TERRANIA, 5.0f);
    }

    protected void registerGoals() {
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)JSounds.TERRA_SLUG.get();
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)JSounds.TERRA_SLUG_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)JSounds.TERRA_SLUG_DEATH.get();
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean canBeLeashed() {
        return false;
    }

    public void push(Entity entity) {
    }

    protected void doPush(Entity entityIn) {
    }

    public boolean isPushable() {
        return false;
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.MOVEMENT_SPEED, 0.0).build();
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack heldItem = player.getMainHandItem();
        if (heldItem.getItem() == Items.GLASS_BOTTLE) {
            this.level().playSound(player, player.getOnPos(), (SoundEvent)JSounds.BOTTLE_PLUG.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.isCreative()) {
                heldItem.shrink(1);
            }
            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), player.position().x, player.position().y, player.position().z, new ItemStack((ItemLike)JItems.BILE_VIAL.get(), 1)));
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }
}

