/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.event;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import java.util.Optional;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JLootTables;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@EventBusSubscriber(modid="jitl")
public class CurioEventHandler {
    @SubscribeEvent
    public static void onPlayerAttacked(LivingDamageEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        if (!entity.level().isClientSide() && entity instanceof Player) {
            Player player = (Player)entity;
            Optional<SlotResult> SKULL = CurioEventHandler.getEquippedCurio((LivingEntity)player, (Item)JItems.SKULL_OF_DECAY.get());
            Optional<SlotResult> DEATH_CAP = CurioEventHandler.getEquippedCurio((LivingEntity)player, (Item)JItems.DEATH_CAP.get());
            Entity entity2 = event.getSource().getEntity();
            if (entity2 instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity2;
                if (SKULL.isPresent()) {
                    attacker.addEffect(new MobEffectInstance(MobEffects.WITHER, 100, 1));
                    SKULL.get().stack().hurtAndBreak(1, (ServerLevel)player.level(), (LivingEntity)player, item -> {});
                }
                if (DEATH_CAP.isPresent()) {
                    attacker.addEffect(new MobEffectInstance(MobEffects.POISON, 100, 1));
                    DEATH_CAP.get().stack().hurtAndBreak(1, (ServerLevel)player.level(), (LivingEntity)player, item -> {});
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockHarvested(BlockDropsEvent event) {
        Player player;
        Optional<SlotResult> LUCKY_CHARM;
        Entity entity;
        ServerLevel world = event.getLevel();
        RandomSource rand = RandomSource.create();
        if (!event.getLevel().isClientSide() && (entity = event.getBreaker()) instanceof Player && (LUCKY_CHARM = CurioEventHandler.getEquippedCurio((LivingEntity)(player = (Player)entity), (Item)JItems.LUCKY_CHARM.get())).isPresent()) {
            LootTable table = Objects.requireNonNull(world.getServer()).reloadableRegistries().getLootTable(JLootTables.LOOT_BASIC);
            ObjectArrayList itemList = table.getRandomItems(new LootParams.Builder(world).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withParameter(LootContextParams.ORIGIN, (Object)player.position()).create(LootContextParamSets.GIFT));
            ItemStack spawn = (ItemStack)itemList.get(rand.nextInt(itemList.size()));
            ItemEntity item = new ItemEntity((Level)world, player.position().x, player.position().y, player.position().z, spawn);
            event.getDrops().add(item);
        }
    }

    private static Optional<SlotResult> getEquippedCurio(LivingEntity entity, @NotNull Item curio) {
        ICuriosItemHandler curios = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)entity).get();
        return curios.findFirstCurio(curio);
    }
}

